/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.wiremock.stringparser.StringParser;
import org.wiremock.url.BaseUrl;
import org.wiremock.url.IllegalBaseUrl;
import org.wiremock.url.Uri;
import org.wiremock.url.UriParser;

public class BaseUrlParser
implements StringParser<BaseUrl> {
    public static final BaseUrlParser INSTANCE = new BaseUrlParser(UriParser.INSTANCE);
    private final UriParser uriParser;

    public BaseUrlParser(UriParser uriParser) {
        this.uriParser = uriParser;
    }

    public Class<BaseUrl> getType() {
        return BaseUrl.class;
    }

    public BaseUrl parse(String stringForm) throws IllegalBaseUrl {
        Uri uri = this.uriParser.parse(stringForm);
        if (uri instanceof BaseUrl) {
            BaseUrl baseUrl = (BaseUrl)uri;
            return baseUrl;
        }
        throw new IllegalBaseUrl(stringForm, "Illegal base url: `" + stringForm + "`; path must be a base path (empty or end in `/`), query must be null, fragment must be null");
    }
}

