/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.wiremock.stringparser.StringParser;
import org.wiremock.url.Authority;
import org.wiremock.url.AuthorityValue;
import org.wiremock.url.Host;
import org.wiremock.url.HostAndPort;
import org.wiremock.url.HostParser;
import org.wiremock.url.IllegalAuthority;
import org.wiremock.url.IllegalUriPart;
import org.wiremock.url.Port;
import org.wiremock.url.UserInfo;
import org.wiremock.url.UserInfoParser;

public final class AuthorityParser
implements StringParser<Authority> {
    public static final AuthorityParser INSTANCE = new AuthorityParser();
    static final String authorityRegex = "(?:(?<userInfo>(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=:]|%[0-9a-fA-F]{2})*)@)?(?<host>\\[(?:(?<ipv6Address>[0-9A-Fa-f:.]+)|v[0-9A-Fa-f]\\.[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=:]+)]|(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=]|%[0-9a-fA-F]{2})*)(?<colonAndPort>:(?<port>[0-9]+)?)?";
    private final Pattern authorityPattern = Pattern.compile("^(?:(?<userInfo>(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=:]|%[0-9a-fA-F]{2})*)@)?(?<host>\\[(?:(?<ipv6Address>[0-9A-Fa-f:.]+)|v[0-9A-Fa-f]\\.[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=:]+)]|(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=]|%[0-9a-fA-F]{2})*)(?<colonAndPort>:(?<port>[0-9]+)?)?$");

    public Class<Authority> getType() {
        return Authority.class;
    }

    public Authority parse(String stringForm) throws IllegalAuthority {
        Matcher matcher = this.authorityPattern.matcher(stringForm);
        if (matcher.matches()) {
            return this.parse(matcher, stringForm);
        }
        throw new IllegalAuthority(stringForm);
    }

    Authority parse(Matcher matcher, String rawAuthority) throws IllegalAuthority {
        try {
            String userInfoString = matcher.group("userInfo");
            UserInfo userInfo = userInfoString == null ? null : UserInfoParser.INSTANCE.parse(userInfoString);
            String hostString = matcher.group("host");
            Host host = HostParser.INSTANCE.parse(hostString);
            Optional<Port> maybePort = AuthorityParser.extractPort(matcher);
            if (userInfo == null && (maybePort == null || maybePort.isPresent())) {
                return HostAndPort.of(host, maybePort != null ? (Port)maybePort.orElse(null) : null);
            }
            return new AuthorityValue(rawAuthority, userInfo, host, maybePort);
        }
        catch (IllegalUriPart cause) {
            throw new IllegalAuthority(rawAuthority, cause);
        }
    }

    Authority of(@Nullable UserInfo userInfo, Host host, @Nullable Port port) {
        if (userInfo == null) {
            return HostAndPort.of(host, port);
        }
        Optional<Port> portOptional = port != null ? Optional.of(port) : null;
        return new AuthorityValue(userInfo, host, portOptional);
    }

    private static @Nullable Optional<Port> extractPort(Matcher matcher) {
        String colonAndPort = matcher.group("colonAndPort");
        if (colonAndPort == null) {
            return null;
        }
        String portString = matcher.group("port");
        return portString != null ? Optional.of(Port.parse(portString)) : Optional.empty();
    }
}

