/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbsoluteUrlValue;
import org.wiremock.url.Authority;
import org.wiremock.url.BaseUrlValue;
import org.wiremock.url.Fragment;
import org.wiremock.url.Host;
import org.wiremock.url.HostAndPort;
import org.wiremock.url.OpaqueUriValue;
import org.wiremock.url.OriginValue;
import org.wiremock.url.Path;
import org.wiremock.url.PathAndQueryValue;
import org.wiremock.url.Port;
import org.wiremock.url.Query;
import org.wiremock.url.QueryBuilder;
import org.wiremock.url.RelativeUrlValue;
import org.wiremock.url.Scheme;
import org.wiremock.url.SchemeRelativeUrlValue;
import org.wiremock.url.ServersideAbsoluteUrlValue;
import org.wiremock.url.Uri;
import org.wiremock.url.UriBaseBuilder;
import org.wiremock.url.UserInfo;

abstract class AbstractUriBaseBuilder<SELF extends UriBaseBuilder<SELF>>
implements UriBaseBuilder<SELF> {
    protected @Nullable Scheme scheme = null;
    protected @Nullable UserInfo userInfo = null;
    protected @Nullable Port port = null;
    protected @Nullable Authority authority = null;
    protected Path path = Path.ROOT;
    protected @Nullable Query query = null;
    protected @Nullable Query.Builder queryBuilder = null;
    protected @Nullable Fragment fragment = null;

    AbstractUriBaseBuilder() {
    }

    AbstractUriBaseBuilder(Uri uri) {
        this.scheme = uri.getScheme();
        this.authority = uri.getAuthority();
        this.path = uri.getPath();
        this.query = uri.getQuery();
        this.fragment = uri.getFragment();
    }

    public @Nullable Scheme getScheme() {
        return this.scheme;
    }

    protected SELF doSetScheme(@Nullable Scheme scheme) {
        this.scheme = scheme;
        return this.getSelf();
    }

    @Override
    public @Nullable Authority getAuthority() {
        return this.authority;
    }

    protected SELF doSetAuthority(@Nullable Authority authority) {
        this.authority = authority;
        this.userInfo = null;
        this.port = null;
        return this.getSelf();
    }

    @Override
    public @Nullable UserInfo getUserInfo() {
        if (this.authority == null) {
            return this.userInfo;
        }
        return this.authority.getUserInfo();
    }

    @Override
    public SELF setUserInfo(@Nullable UserInfo userInfo) {
        if (this.authority == null) {
            this.userInfo = userInfo;
            return this.getSelf();
        }
        return this.doSetAuthority(Authority.of(userInfo, this.authority.getHost(), this.authority.getPort()));
    }

    @Override
    public @Nullable Host getHost() {
        return this.authority != null ? this.authority.getHost() : null;
    }

    @Override
    public SELF setHost(Host host) {
        if (this.authority == null) {
            return this.doSetAuthority(Authority.of(this.userInfo, host, this.port));
        }
        return this.doSetAuthority(Authority.of(this.authority.getUserInfo(), host, this.authority.getPort()));
    }

    @Override
    public @Nullable Port getPort() {
        return this.authority != null ? this.authority.getPort() : null;
    }

    @Override
    public SELF setPort(@Nullable Port port) {
        if (this.authority == null) {
            this.port = port;
            return this.getSelf();
        }
        return this.doSetAuthority(Authority.of(this.authority.getUserInfo(), this.authority.getHost(), port));
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public SELF setPath(Path path) {
        this.path = Objects.requireNonNull(path);
        return this.getSelf();
    }

    @Override
    public @Nullable Query getQuery() {
        return this.query;
    }

    @Override
    public SELF setQuery(@Nullable Query query) {
        this.query = query;
        this.queryBuilder = null;
        return this.getSelf();
    }

    @Override
    public Query.Builder getQueryBuilder() {
        if (this.queryBuilder == null) {
            this.queryBuilder = this.query != null ? new QueryBuilder(this.query.getEntries()) : new QueryBuilder();
        }
        return this.queryBuilder;
    }

    @Override
    public SELF setQueryBuilder(Query.Builder query) {
        Query built = query.build();
        built = built.isEmpty() ? null : built;
        return this.setQuery(built);
    }

    @Override
    public @Nullable Fragment getFragment() {
        return this.fragment;
    }

    @Override
    public SELF setFragment(@Nullable Fragment fragment) {
        this.fragment = fragment;
        return this.getSelf();
    }

    Uri build(@Nullable String stringForm) {
        HostAndPort hostAndPort;
        Authority authority;
        if (this.authority == null && (this.userInfo != null || this.port != null)) {
            throw new IllegalStateException("Cannot construct a uri with a userinfo or port but no host");
        }
        if (this.queryBuilder != null) {
            this.setQueryBuilder(this.queryBuilder);
        }
        if (this.scheme == null) {
            if (this.authority == null && this.fragment == null && (this.path.isEmpty() || this.path.isAbsolute())) {
                return new PathAndQueryValue(stringForm, this.path, this.query);
            }
            if (this.authority != null) {
                return new SchemeRelativeUrlValue(stringForm, this.authority, this.path, this.query, this.fragment);
            }
            return new RelativeUrlValue(stringForm, this.path, this.query, this.fragment);
        }
        if (this.authority == null) {
            return new OpaqueUriValue(stringForm, this.scheme, this.path, this.query, this.fragment);
        }
        if (this.scheme.isNormalForm() && (authority = this.authority) instanceof HostAndPort && (hostAndPort = (HostAndPort)authority).isNormalForm(this.scheme) && this.path.isEmpty() && this.query == null && this.fragment == null) {
            return new OriginValue(stringForm, this.scheme, hostAndPort);
        }
        if (this.fragment == null) {
            if (this.query == null && this.path.isBase()) {
                return new BaseUrlValue(stringForm, this.scheme, this.authority, this.path);
            }
            return new ServersideAbsoluteUrlValue(stringForm, this.scheme, this.authority, this.path, this.query);
        }
        return new AbsoluteUrlValue(stringForm, this.scheme, this.authority, this.path, this.query, this.fragment);
    }

    @Override
    public Uri build() {
        return this.build(null);
    }

    private SELF getSelf() {
        return (SELF)this;
    }
}

