/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbsoluteUri;
import org.wiremock.url.AbstractUriValue;
import org.wiremock.url.Authority;
import org.wiremock.url.Fragment;
import org.wiremock.url.MemoisedNormalisable;
import org.wiremock.url.Path;
import org.wiremock.url.Query;
import org.wiremock.url.Scheme;
import org.wiremock.url.Uri;

abstract class AbstractAbsoluteUriValue<NORMALISED extends AbsoluteUri>
extends AbstractUriValue
implements AbsoluteUri {
    protected final Scheme nonNullScheme;
    private final MemoisedNormalisable<AbsoluteUri> memoisedNormalisable;

    AbstractAbsoluteUriValue(@Nullable String stringValue, Scheme scheme, @Nullable Authority authority, Path path, @Nullable Query query, @Nullable Fragment fragment) {
        super(stringValue, scheme, authority, path, query, fragment);
        this.nonNullScheme = Objects.requireNonNull(scheme);
        this.memoisedNormalisable = new MemoisedNormalisable<AbsoluteUri>(this, this::doIsNormalForm, this::doNormalise);
    }

    @Override
    public Scheme getScheme() {
        return this.nonNullScheme;
    }

    @Override
    public @NonNull NORMALISED normalise() {
        return this.getNormalised(this.memoisedNormalisable.normalise());
    }

    private AbsoluteUri doNormalise() {
        Scheme normalisedScheme = this.scheme != null ? this.scheme.normalise() : null;
        Authority normalisedAuthority = this.getNormalisedAuthority(normalisedScheme);
        Path normalisedPath = this.path.normalise();
        if (normalisedPath.isEmpty()) {
            normalisedPath = Path.ROOT;
        }
        Query normalisedQuery = this.query == null ? null : this.query.normalise();
        Fragment normalisedFragment = this.fragment == null ? null : this.fragment.normalise();
        Uri uri = Objects.equals(normalisedScheme, this.scheme) && Objects.equals(normalisedAuthority, this.authority) && Objects.equals(normalisedPath, this.path) && Objects.equals(normalisedQuery, this.query) && Objects.equals(normalisedFragment, this.fragment) ? this : ((Uri.Builder)((Uri.Builder)((Uri.Builder)Uri.builder().setScheme(normalisedScheme).setAuthority(normalisedAuthority).setPath(normalisedPath)).setQuery(normalisedQuery)).setFragment(normalisedFragment)).build();
        return this.getNormalised(uri);
    }

    private NORMALISED getNormalised(Uri uri) {
        return (NORMALISED)((AbsoluteUri)uri);
    }

    @Override
    public boolean isNormalForm() {
        return this.memoisedNormalisable.isNormalForm();
    }

    private boolean doIsNormalForm() {
        return AbsoluteUri.super.isNormalForm();
    }

    private @Nullable Authority getNormalisedAuthority(@Nullable Scheme normalisedScheme) {
        if (this.authority == null) {
            return null;
        }
        return normalisedScheme == null ? (Authority)this.authority.normalise() : this.authority.normalise(normalisedScheme);
    }
}

