/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.function.Consumer;
import org.wiremock.url.AbsoluteUriBuilder;
import org.wiremock.url.AbsoluteUriParser;
import org.wiremock.url.AbsoluteUriTransformer;
import org.wiremock.url.AbsoluteUrl;
import org.wiremock.url.Authority;
import org.wiremock.url.Fragment;
import org.wiremock.url.IllegalAbsoluteUri;
import org.wiremock.url.Normalisable;
import org.wiremock.url.Path;
import org.wiremock.url.Query;
import org.wiremock.url.RelativeUrl;
import org.wiremock.url.Scheme;
import org.wiremock.url.Uri;
import org.wiremock.url.UriBaseBuilder;
import org.wiremock.url.UrlWithAuthority;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AbsoluteUri
extends Uri,
Normalisable<AbsoluteUri> {
    @Override
    public Scheme getScheme();

    @Override
    default public boolean isRelative() {
        return false;
    }

    @Override
    default public boolean isAbsolute() {
        return true;
    }

    @Override
    public AbsoluteUri normalise();

    @Override
    default public boolean isNormalForm() {
        Scheme scheme = this.getScheme();
        Authority authority = this.getAuthority();
        Path path = this.getPath();
        Query query = this.getQuery();
        Fragment fragment = this.getFragment();
        return !(!scheme.isNormalForm() || authority != null && !authority.isNormalForm(scheme) || !path.isNormalForm() || !path.toString().startsWith("/") || query != null && !query.isNormalForm() || fragment != null && !fragment.isNormalForm());
    }

    default public AbsoluteUrl resolve(UrlWithAuthority other) {
        if (other instanceof AbsoluteUrl) {
            AbsoluteUrl otherUrl = (AbsoluteUrl)other;
            return otherUrl.normalise();
        }
        AbsoluteUrl.Builder builder = AbsoluteUrl.builder(this.getScheme(), (Authority)other.getAuthority().normalise());
        Path otherPath = other.getPath();
        Path path = otherPath.isEmpty() ? Path.ROOT : otherPath.normalise();
        builder.setPath(path);
        Query otherQuery = other.getQuery();
        builder.setQuery(otherQuery != null ? otherQuery.normalise() : null);
        Fragment otherFragment = other.getFragment();
        builder.setFragment(otherFragment != null ? otherFragment.normalise() : null);
        return builder.build();
    }

    default public AbsoluteUri resolve(Uri other) {
        if (other instanceof AbsoluteUri) {
            AbsoluteUri otherUri = (AbsoluteUri)other;
            return otherUri.normalise();
        }
        Builder<?> builder = AbsoluteUri.builder(this);
        Authority otherAuthority = other.getAuthority();
        Path otherPath = other.getPath();
        Query otherQuery = other.getQuery();
        Fragment otherFragment = other.getFragment();
        if (otherAuthority != null) {
            builder.setAuthority((Authority)otherAuthority.normalise());
            Path path = otherPath.isEmpty() ? Path.ROOT : otherPath.normalise();
            builder.setPath(path);
            builder.setQuery(otherQuery != null ? otherQuery.normalise() : null);
        } else if (otherPath.isEmpty()) {
            builder.setPath(this.normalise().getPath());
            if (otherQuery != null) {
                builder.setQuery(otherQuery.normalise());
            }
        } else {
            if (otherPath.isAbsolute()) {
                builder.setPath(otherPath.normalise());
            } else {
                builder.setPath(this.normalise().getPath().resolve(otherPath));
            }
            builder.setQuery(otherQuery != null ? otherQuery.normalise() : null);
        }
        otherFragment = otherFragment != null ? otherFragment.normalise() : null;
        builder.setFragment(otherFragment);
        return builder.build();
    }

    default public AbsoluteUri resolve(Path other) {
        RelativeUrl relative = ((RelativeUrl.Builder)RelativeUrl.builder().setPath(other)).build();
        return this.resolve(relative);
    }

    default public Transformer<?> thaw() {
        return new AbsoluteUriTransformer(this);
    }

    default public AbsoluteUri transform(Consumer<Uri.Transformer<?>> mutator) {
        Transformer<?> transformer = this.thaw();
        mutator.accept(transformer);
        return transformer.build();
    }

    public static Builder<?> builder(Scheme scheme) {
        return new AbsoluteUriBuilder(scheme);
    }

    public static Builder<?> builder(AbsoluteUri uri) {
        return new AbsoluteUriBuilder(uri);
    }

    public static AbsoluteUri parse(String uriString) throws IllegalAbsoluteUri {
        return AbsoluteUriParser.INSTANCE.parse(uriString);
    }

    public static interface Builder<SELF extends Builder<SELF>>
    extends UriBaseBuilder<SELF> {
        public Scheme getScheme();

        public SELF setScheme(Scheme var1);

        @Override
        public AbsoluteUri build();
    }

    public static interface Transformer<SELF extends Transformer<SELF>>
    extends Uri.Transformer<SELF> {
        @Override
        public AbsoluteUri build();
    }
}

