/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.wiremock.url.PercentEncoding;
import org.wiremock.url.UserInfoParser;
import org.wiremock.url.Username;

final class UsernameValue
implements Username {
    private final String username;
    private final boolean isNormalForm;

    UsernameValue(String username) {
        this(username, false);
    }

    UsernameValue(String username, boolean isNormalForm) {
        this.username = username;
        this.isNormalForm = isNormalForm;
    }

    @Override
    public Username normalise() {
        if (this.isNormalForm) {
            return this;
        }
        String result = PercentEncoding.normalise(this.username, UserInfoParser.usernameCharSet);
        if (result == null) {
            return this;
        }
        return new UsernameValue(result, true);
    }

    @Override
    public boolean isNormalForm() {
        return this.isNormalForm || PercentEncoding.isNormalForm(this.username, UserInfoParser.usernameCharSet);
    }

    public String toString() {
        return this.username;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Username) {
            Username that = (Username)obj;
            return Objects.equals(this.toString(), that.toString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.username);
    }
}

