/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.regex.Pattern;
import org.wiremock.url.Constants;
import org.wiremock.url.IllegalUsername;
import org.wiremock.url.PercentEncodedStringParser;
import org.wiremock.url.PercentEncoding;
import org.wiremock.url.Username;
import org.wiremock.url.UsernameValue;

public final class UsernameParser
implements PercentEncodedStringParser<Username> {
    public static final UsernameParser INSTANCE = new UsernameParser();
    final String usernameRegex = "(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=]|%[0-9a-fA-F]{2})*";
    private final Pattern usernamePattern = Pattern.compile("^(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=]|%[0-9a-fA-F]{2})*$");
    private static final boolean[] usernameCharSet = Constants.combine(Constants.unreservedCharSet, new boolean[][]{Constants.subDelimCharSet});

    public Class<Username> getType() {
        return Username.class;
    }

    public Username parse(String stringForm) throws IllegalUsername {
        if (this.usernamePattern.matcher(stringForm).matches()) {
            return new UsernameValue(stringForm);
        }
        throw new IllegalUsername(stringForm);
    }

    @Override
    public Username encode(String unencoded) {
        String encoded = PercentEncoding.encode(unencoded, usernameCharSet);
        return new UsernameValue(encoded);
    }
}

