/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbstractUriBaseBuilder;
import org.wiremock.url.Authority;
import org.wiremock.url.IllegalUrl;
import org.wiremock.url.Scheme;
import org.wiremock.url.Uri;
import org.wiremock.url.Url;

final class UrlTransformer
extends AbstractUriBaseBuilder<UrlTransformer>
implements Url.Transformer<UrlTransformer> {
    UrlTransformer(Url url) {
        super(url);
    }

    @Override
    public Url build() {
        Uri uri = super.build();
        if (uri instanceof Url) {
            Url url = (Url)uri;
            return url;
        }
        throw new IllegalUrl(uri.toString(), "Illegal url: `" + String.valueOf(uri) + "`; a url has an authority");
    }

    @Override
    public @Nullable Scheme getScheme() {
        return this.scheme;
    }

    @Override
    public UrlTransformer setScheme(@Nullable Scheme scheme) {
        return (UrlTransformer)super.doSetScheme(scheme);
    }

    @Override
    public @Nullable Authority getAuthority() {
        return this.authority;
    }

    @Override
    public UrlTransformer setAuthority(@Nullable Authority authority) {
        return (UrlTransformer)super.doSetAuthority(authority);
    }
}

