/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.wiremock.stringparser.StringParser;
import org.wiremock.url.IllegalUrl;
import org.wiremock.url.Uri;
import org.wiremock.url.UriParser;
import org.wiremock.url.Url;

public final class UrlParser
implements StringParser<Url> {
    public static final UrlParser INSTANCE = new UrlParser(UriParser.INSTANCE);
    private final UriParser uriParser;

    public UrlParser(UriParser uriParser) {
        this.uriParser = uriParser;
    }

    public Class<Url> getType() {
        return Url.class;
    }

    public Url parse(String stringForm) {
        Uri uri = this.uriParser.parse(stringForm);
        if (uri instanceof Url) {
            Url url = (Url)uri;
            return url;
        }
        throw new IllegalUrl(stringForm, "Illegal url: `" + String.valueOf(uri) + "`; a url has an authority");
    }
}

