/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.Authority;
import org.wiremock.url.IllegalUri;
import org.wiremock.url.PathAndQuery;
import org.wiremock.url.PathAndQueryValue;
import org.wiremock.url.Scheme;
import org.wiremock.url.Uri;
import org.wiremock.url.UriBaseBuilder;
import org.wiremock.url.UrlBuilder;
import org.wiremock.url.UrlParser;
import org.wiremock.url.UrlTransformer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Url
extends Uri {
    default public PathAndQuery getPathAndQuery() {
        return new PathAndQueryValue(this.getPath(), this.getQuery());
    }

    default public Transformer<?> thaw() {
        return new UrlTransformer(this);
    }

    default public Url transform(Consumer<Uri.Transformer<?>> mutator) throws IllegalUri {
        Transformer<?> transformer = this.thaw();
        mutator.accept(transformer);
        return transformer.build();
    }

    public static Builder builder() {
        return new UrlBuilder();
    }

    public static Builder builder(Url url) {
        return new UrlBuilder(url);
    }

    public static Url parse(String url) throws IllegalUri {
        return UrlParser.INSTANCE.parse(url);
    }

    public static interface Transformer<SELF extends Transformer<SELF>>
    extends Uri.Transformer<SELF> {
        @Override
        public Url build() throws IllegalUri;
    }

    public static interface Builder
    extends UriBaseBuilder<Builder> {
        public @Nullable Scheme getScheme();

        public Builder setScheme(@Nullable Scheme var1);

        @Override
        public Builder setAuthority(@Nullable Authority var1);

        @Override
        public Url build() throws IllegalUri;
    }
}

