/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.net.URI;
import org.jspecify.annotations.Nullable;
import org.wiremock.stringparser.ParsedString;
import org.wiremock.url.Authority;
import org.wiremock.url.Fragment;
import org.wiremock.url.Host;
import org.wiremock.url.IllegalUri;
import org.wiremock.url.Path;
import org.wiremock.url.Port;
import org.wiremock.url.Query;
import org.wiremock.url.Scheme;
import org.wiremock.url.UriBaseBuilder;
import org.wiremock.url.UriBuilder;
import org.wiremock.url.UriParser;
import org.wiremock.url.UserInfo;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Uri
extends ParsedString {
    public @Nullable Scheme getScheme();

    public @Nullable Authority getAuthority();

    public Path getPath();

    public @Nullable Query getQuery();

    default public Query getQueryOrEmpty() {
        Query query = this.getQuery();
        return query != null ? query : Query.EMPTY;
    }

    public @Nullable Fragment getFragment();

    public boolean isRelative();

    public boolean isAbsolute();

    public boolean isAbsoluteUrl();

    public boolean isOpaqueUri();

    default public @Nullable UserInfo getUserInfo() {
        Authority authority = this.getAuthority();
        return authority != null ? authority.getUserInfo() : null;
    }

    default public @Nullable Host getHost() {
        Authority authority = this.getAuthority();
        return authority != null ? authority.getHost() : null;
    }

    default public @Nullable Port getPort() {
        Authority authority = this.getAuthority();
        return authority != null ? authority.getPort() : null;
    }

    default public @Nullable Port getResolvedPort() {
        Port definedPort = this.getPort();
        Scheme scheme = this.getScheme();
        return definedPort != null ? definedPort : (scheme != null ? scheme.getDefaultPort() : null);
    }

    default public URI toJavaUri() throws IllegalArgumentException {
        return URI.create(this.toString());
    }

    public static Uri parse(String uri) throws IllegalUri {
        return UriParser.INSTANCE.parse(uri);
    }

    public static Uri of(URI uri) {
        return Uri.parse(uri.toASCIIString());
    }

    public static Builder builder() {
        return new UriBuilder();
    }

    public static Builder builder(Uri uri) {
        return new UriBuilder(uri);
    }

    public static interface Transformer<SELF extends Transformer<SELF>>
    extends UriBaseBuilder<SELF> {
        public @Nullable Scheme getScheme();

        public SELF setScheme(Scheme var1);
    }

    public static interface Builder
    extends UriBaseBuilder<Builder> {
        public @Nullable Scheme getScheme();

        public Builder setScheme(@Nullable Scheme var1);

        @Override
        public Builder setAuthority(@Nullable Authority var1);
    }
}

