/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.MemoisedNormalisable;
import org.wiremock.url.PercentEncoding;
import org.wiremock.url.Segment;
import org.wiremock.url.SegmentParser;

final class SegmentValue
implements Segment {
    private final String stringForm;
    private final MemoisedNormalisable<Segment> memoisedNormalisable;

    SegmentValue(String stringForm) {
        this(stringForm, null);
    }

    SegmentValue(String stringForm, @Nullable Boolean isNormalForm) {
        this.stringForm = stringForm;
        this.memoisedNormalisable = new MemoisedNormalisable<Segment>(this, isNormalForm, this::isNormalFormWork, this::normaliseWork);
    }

    public String toString() {
        return this.stringForm;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Segment) {
            Segment that = (Segment)obj;
            return Objects.equals(this.toString(), that.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.stringForm.hashCode();
    }

    @Override
    public Segment normalise() {
        return this.memoisedNormalisable.normalise();
    }

    private @Nullable Segment normaliseWork() {
        String result = PercentEncoding.normalise(this.stringForm, SegmentParser.segmentCharSet);
        return result != null ? SegmentParser.INSTANCE.build(result, () -> new SegmentValue(result, true)) : null;
    }

    @Override
    public boolean isNormalForm() {
        return this.memoisedNormalisable.isNormalForm();
    }

    private boolean isNormalFormWork() {
        return PercentEncoding.isNormalForm(this.stringForm, SegmentParser.segmentCharSet);
    }
}

