/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.Port;
import org.wiremock.url.Scheme;

final class SchemeValue
implements Scheme {
    private final String scheme;
    private final @Nullable Scheme normalForm;
    private final @Nullable Port defaultPort;

    SchemeValue(String scheme, @Nullable Scheme normalForm, @Nullable Port defaultPort) {
        this.scheme = scheme;
        this.normalForm = normalForm;
        this.defaultPort = defaultPort;
    }

    @Override
    public Scheme normalise() {
        return Objects.requireNonNullElse(this.normalForm, this);
    }

    @Override
    public @Nullable Port getDefaultPort() {
        if (this.defaultPort != null) {
            return this.defaultPort;
        }
        if (this.normalForm != null) {
            return this.normalForm.getDefaultPort();
        }
        return null;
    }

    public String toString() {
        return this.scheme;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Scheme)) {
            return false;
        }
        Scheme other = (Scheme)o;
        return Objects.equals(this.scheme, other.toString());
    }

    public int hashCode() {
        return this.scheme.hashCode();
    }
}

