/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbstractUriValue;
import org.wiremock.url.Authority;
import org.wiremock.url.Fragment;
import org.wiremock.url.IllegalPath;
import org.wiremock.url.IllegalSchemeRelativeUrl;
import org.wiremock.url.Path;
import org.wiremock.url.Query;
import org.wiremock.url.SchemeRelativeUrl;

final class SchemeRelativeUrlValue
extends AbstractUriValue
implements SchemeRelativeUrl {
    private final Authority nonNullAuthority;

    SchemeRelativeUrlValue(@Nullable String stringValue, Authority authority, Path path, @Nullable Query query, @Nullable Fragment fragment) {
        super(stringValue, null, authority, path, query, fragment);
        this.nonNullAuthority = Objects.requireNonNull(authority);
        if (!path.isEmpty() && !path.isAbsolute()) {
            throw new IllegalSchemeRelativeUrl(this.toString(), "Illegal scheme relative url: `" + String.valueOf(this) + "` - a scheme relative url's path must be absolute or empty, was `" + String.valueOf(path) + "`", new IllegalPath(path.toString(), "Illegal path: `" + String.valueOf(path) + "` - must be absolute or empty"));
        }
    }

    @Override
    public Authority getAuthority() {
        return this.nonNullAuthority;
    }
}

