/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.jspecify.annotations.Nullable;
import org.wiremock.stringparser.StringParser;
import org.wiremock.url.DefaultSchemeRegistry;
import org.wiremock.url.IllegalScheme;
import org.wiremock.url.Port;
import org.wiremock.url.Scheme;

public interface SchemeRegistry
extends StringParser<Scheme> {
    public static final SchemeRegistry INSTANCE = new DefaultSchemeRegistry();
    public static final Scheme http = INSTANCE.register("http", Port.of(80));
    public static final Scheme https = INSTANCE.register("https", Port.of(443));
    public static final Scheme ws = INSTANCE.register("ws", Port.of(80));
    public static final Scheme wss = INSTANCE.register("wss", Port.of(443));
    public static final Scheme file = INSTANCE.register("file");
    public static final Scheme ftp = INSTANCE.register("ftp", Port.of(21));
    public static final Scheme sftp = INSTANCE.register("sftp", Port.of(22));
    public static final Scheme ssh = INSTANCE.register("ssh", Port.of(22));
    public static final Scheme mailto = INSTANCE.register("mailto");

    default public Class<Scheme> getType() {
        return Scheme.class;
    }

    default public Scheme register(String schemeString) throws IllegalScheme {
        return this.register(schemeString, null);
    }

    public Scheme register(String var1, @Nullable Port var2) throws IllegalScheme;
}

