/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.jspecify.annotations.Nullable;
import org.wiremock.url.Authority;
import org.wiremock.url.IllegalRelativeUrl;
import org.wiremock.url.RelativeUrlBuilder;
import org.wiremock.url.RelativeUrlParser;
import org.wiremock.url.RelativeUrlTransformer;
import org.wiremock.url.Scheme;
import org.wiremock.url.UriBaseBuilder;
import org.wiremock.url.Url;

public interface RelativeUrl
extends Url {
    @Override
    @Deprecated
    default public @Nullable Scheme getScheme() {
        return null;
    }

    @Override
    default public boolean isRelative() {
        return true;
    }

    @Override
    default public boolean isAbsolute() {
        return false;
    }

    @Override
    default public boolean isAbsoluteUrl() {
        return false;
    }

    @Override
    default public boolean isOpaqueUri() {
        return false;
    }

    default public Transformer thaw() {
        return new RelativeUrlTransformer(this);
    }

    public static RelativeUrl parse(String relativeRef) throws IllegalRelativeUrl {
        return RelativeUrlParser.INSTANCE.parse(relativeRef);
    }

    public static Builder builder() {
        return new RelativeUrlBuilder();
    }

    public static Builder builder(RelativeUrl url) {
        return new RelativeUrlBuilder(url);
    }

    public static interface Transformer
    extends Url.Transformer<Transformer> {
        @Override
        public Transformer setScheme(@Nullable Scheme var1);

        @Override
        public Transformer setAuthority(@Nullable Authority var1);
    }

    public static interface Builder
    extends UriBaseBuilder<Builder> {
        @Override
        public Builder setAuthority(@Nullable Authority var1);

        @Override
        public RelativeUrl build() throws IllegalRelativeUrl;
    }
}

