/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.Lazy;
import org.wiremock.url.Lists;
import org.wiremock.url.MemoisedNormalisable;
import org.wiremock.url.PercentEncoding;
import org.wiremock.url.Query;
import org.wiremock.url.QueryBuilder;
import org.wiremock.url.QueryParamKey;
import org.wiremock.url.QueryParamKeyValue;
import org.wiremock.url.QueryParamValue;
import org.wiremock.url.QueryParamValueValue;
import org.wiremock.url.QueryParser;

final class QueryValue
implements Query {
    private final String query;
    private final Lazy<List<Map.Entry<QueryParamKey, @Nullable QueryParamValue>>> paramEntries;
    private final MemoisedNormalisable<Query> memoisedNormalisable;
    private volatile @Nullable Map<QueryParamKey, List<@Nullable QueryParamValue>> asMap = null;

    QueryValue(String query) {
        this(query, null);
    }

    QueryValue(String query, @Nullable Boolean isNormalForm) {
        this(query, null, isNormalForm);
    }

    QueryValue(List<Map.Entry<QueryParamKey, @Nullable QueryParamValue>> params) {
        this(params, null);
    }

    QueryValue(List<Map.Entry<QueryParamKey, @Nullable QueryParamValue>> params, @Nullable Boolean isNormalForm) {
        this(QueryValue.joinToString(params), Collections.unmodifiableList(params), isNormalForm);
    }

    private static String joinToString(List<Map.Entry<QueryParamKey, @Nullable QueryParamValue>> params) {
        return params.stream().map(entry -> {
            QueryParamValue value = (QueryParamValue)entry.getValue();
            return value == null ? ((QueryParamKey)entry.getKey()).toString() : String.valueOf(entry.getKey()) + "=" + String.valueOf(value);
        }).collect(Collectors.joining("&"));
    }

    QueryValue(String query, @Nullable List<Map.Entry<QueryParamKey, @Nullable QueryParamValue>> paramEntries, @Nullable Boolean isNormalForm) {
        this.query = query;
        this.paramEntries = Lazy.lazy(paramEntries, this::parseEntries);
        this.memoisedNormalisable = new MemoisedNormalisable<Query>(this, isNormalForm, this::isNormalFormWork, this::normaliseWork);
    }

    public String toString() {
        return this.query;
    }

    @Override
    public Query normalise() {
        return this.memoisedNormalisable.normalise();
    }

    private @Nullable Query normaliseWork() {
        String result = PercentEncoding.simpleNormalise(this.query, QueryParser.queryCharSet);
        return result != null ? new QueryValue(result, (Boolean)true) : null;
    }

    @Override
    public boolean isNormalForm() {
        return this.memoisedNormalisable.isNormalForm();
    }

    private boolean isNormalFormWork() {
        return PercentEncoding.isSimpleNormalForm(this.query, QueryParser.queryCharSet);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Map<QueryParamKey, List<@Nullable QueryParamValue>> asMap() {
        @Nullable Map local = this.asMap;
        if (local == null) {
            this.asMap = local = Query.super.asMap();
        }
        return local;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Query) {
            Query that = (Query)obj;
            return Objects.equals(this.toString(), that.toString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.query);
    }

    @Override
    public Query.Builder thaw() {
        return new QueryBuilder(this.getEntries());
    }

    @Override
    public List<Map.Entry<QueryParamKey, @Nullable QueryParamValue>> getEntries() {
        return this.paramEntries.get();
    }

    private List<Map.Entry<QueryParamKey, @Nullable QueryParamValue>> parseEntries() {
        String[] keyValuePairStrs = this.query.split("&", -1);
        ArrayList<AbstractMap.SimpleEntry<QueryParamKeyValue, QueryParamValueValue>> result = new ArrayList<AbstractMap.SimpleEntry<QueryParamKeyValue, QueryParamValueValue>>();
        for (String keyValuePairStr : keyValuePairStrs) {
            String[] keyValuePair = keyValuePairStr.split("=", 2);
            QueryParamKeyValue key = new QueryParamKeyValue(keyValuePair[0]);
            QueryParamValueValue value = keyValuePair.length == 2 ? new QueryParamValueValue(keyValuePair[1]) : null;
            result.add(new AbstractMap.SimpleEntry<QueryParamKeyValue, QueryParamValueValue>(key, value));
        }
        return Collections.unmodifiableList(result);
    }

    static List<@Nullable QueryParamValue> encodeValues(@Nullable String value, @Nullable String[] otherValues) {
        return Lists.of(value, otherValues).stream().map(QueryValue::encodeValue).toList();
    }

    private static @Nullable QueryParamValue encodeValue(@Nullable String value) {
        return value != null ? QueryParamValue.encode(value) : null;
    }
}

