/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.regex.Pattern;
import org.wiremock.url.Constants;
import org.wiremock.url.IllegalQuery;
import org.wiremock.url.PercentEncodedStringParser;
import org.wiremock.url.PercentEncoding;
import org.wiremock.url.Query;
import org.wiremock.url.QueryValue;

public final class QueryParser
implements PercentEncodedStringParser<Query> {
    public static final QueryParser INSTANCE = new QueryParser();
    static final String queryRegex = "[^#\\u0000-\\u0008\\u000A-\\u001F\\u007F\\u0080-\\u009F\\uD800-\\uDFFF]*";
    private final Pattern queryPattern = Pattern.compile("^[^#\\u0000-\\u0008\\u000A-\\u001F\\u007F\\u0080-\\u009F\\uD800-\\uDFFF]*$");
    static final boolean[] queryCharSet = Constants.combine(Constants.pcharCharSet, new boolean[][]{Constants.include('/', '?')});

    public Class<Query> getType() {
        return Query.class;
    }

    public Query parse(String stringForm) throws IllegalQuery {
        if (stringForm.isEmpty()) {
            return Query.EMPTY;
        }
        if (this.queryPattern.matcher(stringForm).matches()) {
            return new QueryValue(stringForm);
        }
        throw new IllegalQuery(stringForm);
    }

    @Override
    public Query encode(String unencoded) {
        if (unencoded.isEmpty()) {
            return Query.EMPTY;
        }
        String result = PercentEncoding.encode(unencoded, queryCharSet);
        return new QueryValue(result);
    }
}

