/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.MemoisedNormalisable;
import org.wiremock.url.PercentEncoding;
import org.wiremock.url.QueryParamValue;
import org.wiremock.url.QueryParamValueParser;

final class QueryParamValueValue
implements QueryParamValue {
    private final String stringForm;
    private final MemoisedNormalisable<QueryParamValue> memoisedNormalisable;

    public QueryParamValueValue(String stringForm) {
        this(stringForm, null);
    }

    QueryParamValueValue(String stringForm, @Nullable Boolean isNormalForm) {
        this.stringForm = stringForm;
        this.memoisedNormalisable = new MemoisedNormalisable<QueryParamValue>(this, isNormalForm, this::isNormalFormWork, this::normaliseWork);
    }

    public String toString() {
        return this.stringForm;
    }

    @Override
    public String decode() {
        return PercentEncoding.decode(this.stringForm.replace('+', ' '));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryParamValue) {
            QueryParamValue that = (QueryParamValue)obj;
            return Objects.equals(this.toString(), that.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.stringForm.hashCode();
    }

    @Override
    public QueryParamValue normalise() {
        return this.memoisedNormalisable.normalise();
    }

    private @Nullable QueryParamValue normaliseWork() {
        String result = PercentEncoding.normalise(this.stringForm.replace('+', ' '), QueryParamValueParser.queryParamValueCharSet);
        return result != null ? new QueryParamValueValue(result, true) : null;
    }

    @Override
    public boolean isNormalForm() {
        return this.memoisedNormalisable.isNormalForm();
    }

    private boolean isNormalFormWork() {
        return PercentEncoding.isNormalForm(this.stringForm, QueryParamValueParser.queryParamValueCharSet);
    }
}

