/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.regex.Pattern;
import org.wiremock.url.Constants;
import org.wiremock.url.IllegalSegment;
import org.wiremock.url.PercentEncodedStringParser;
import org.wiremock.url.PercentEncoding;
import org.wiremock.url.QueryParamKey;
import org.wiremock.url.QueryParamKeyValue;
import org.wiremock.url.QueryParser;

public final class QueryParamKeyParser
implements PercentEncodedStringParser<QueryParamKey> {
    public static final QueryParamKeyParser INSTANCE = new QueryParamKeyParser();
    private static final String queryParamKeyRegex = "[^#&=\\u0000-\\u0008\\u000A-\\u001F\\u007F\\u0080-\\u009F\\uD800-\\uDFFF]*";
    private static final Pattern queryParamKeyPattern = Pattern.compile("^[^#&=\\u0000-\\u0008\\u000A-\\u001F\\u007F\\u0080-\\u009F\\uD800-\\uDFFF]*$");
    static final boolean[] queryParamKeyCharSet = Constants.remove(QueryParser.queryCharSet, '&', '=', '+');

    public Class<QueryParamKey> getType() {
        return QueryParamKey.class;
    }

    public QueryParamKey parse(String stringForm) {
        if (stringForm.isEmpty()) {
            return QueryParamKey.EMPTY;
        }
        if (queryParamKeyPattern.matcher(stringForm).matches()) {
            return new QueryParamKeyValue(stringForm);
        }
        throw new IllegalSegment(stringForm);
    }

    @Override
    public QueryParamKey encode(String unencoded) {
        return unencoded.isEmpty() ? QueryParamKey.EMPTY : new QueryParamKeyValue(PercentEncoding.encode(unencoded, queryParamKeyCharSet), true);
    }
}

