/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.jspecify.annotations.Nullable;
import org.wiremock.url.AppendableToAwareStringBuilder;
import org.wiremock.url.CodePoint;
import org.wiremock.url.CodePointOrHexCodePoint;
import org.wiremock.url.CodePointStream;
import org.wiremock.url.Constants;
import org.wiremock.url.HexCodePoint;
import org.wiremock.url.PercentEncodedStream;

final class PercentEncoding {
    static String decode(String input) {
        AppendableToAwareStringBuilder result = new AppendableToAwareStringBuilder();
        PercentEncodedStream percentEncodedStream = new PercentEncodedStream(input);
        while (percentEncodedStream.hasNext()) {
            result.append(percentEncodedStream.next().decode());
        }
        return result.toString();
    }

    PercentEncoding() {
        throw new UnsupportedOperationException("not instantiable");
    }

    static @Nullable String normalise(String original, boolean[] charactersThatDoNotNeedEncoding) {
        return PercentEncoding.normalise(original, charactersThatDoNotNeedEncoding, Constants.empty);
    }

    static @Nullable String normalise(String original, boolean[] charactersThatDoNotNeedEncoding, boolean[] charactersToLeaveAsIs) {
        AppendableToAwareStringBuilder result = new AppendableToAwareStringBuilder();
        boolean changed = false;
        PercentEncodedStream percentEncodedStream = new PercentEncodedStream(original);
        while (percentEncodedStream.hasNext()) {
            CodePointOrHexCodePoint charOrHex = percentEncodedStream.next();
            if (charOrHex instanceof HexCodePoint) {
                HexCodePoint hex = (HexCodePoint)charOrHex;
                CodePoint decodedChar = hex.decode();
                if (decodedChar.isIn(charactersThatDoNotNeedEncoding) && !decodedChar.isIn(charactersToLeaveAsIs)) {
                    result.append(decodedChar);
                    changed = true;
                    continue;
                }
                HexCodePoint upperCased = hex.toUpperCase();
                result.append(upperCased);
                if (upperCased.equals(hex)) continue;
                changed = true;
                continue;
            }
            if (!(charOrHex instanceof CodePoint)) continue;
            CodePoint codePoint = (CodePoint)charOrHex;
            CodePointOrHexCodePoint maybeEncoded = codePoint.maybePercentEncode(charactersThatDoNotNeedEncoding);
            result.append(maybeEncoded);
            changed = maybeEncoded.isEncoded() || changed;
        }
        if (!changed) {
            return null;
        }
        return result.toString();
    }

    static @Nullable String simpleNormalise(String original, boolean[] charactersThatDoNotNeedEncoding) {
        AppendableToAwareStringBuilder result = new AppendableToAwareStringBuilder();
        boolean changed = false;
        PercentEncodedStream percentEncodedStream = new PercentEncodedStream(original);
        while (percentEncodedStream.hasNext()) {
            CodePointOrHexCodePoint charOrHex = percentEncodedStream.next();
            if (charOrHex instanceof HexCodePoint) {
                HexCodePoint hex = (HexCodePoint)charOrHex;
                HexCodePoint upperCased = hex.toUpperCase();
                result.append(upperCased);
                if (upperCased.equals(hex)) continue;
                changed = true;
                continue;
            }
            if (!(charOrHex instanceof CodePoint)) continue;
            CodePoint codePoint = (CodePoint)charOrHex;
            CodePointOrHexCodePoint maybeEncoded = codePoint.maybePercentEncode(charactersThatDoNotNeedEncoding);
            result.append(maybeEncoded);
            changed = maybeEncoded.isEncoded() || changed;
        }
        if (!changed) {
            return null;
        }
        return result.toString();
    }

    static boolean isSimpleNormalForm(String original, boolean[] charactersThatDoNotNeedEncoding) {
        PercentEncodedStream percentEncodedStream = new PercentEncodedStream(original);
        while (percentEncodedStream.hasNext()) {
            CodePoint codePoint;
            HexCodePoint hex;
            CodePointOrHexCodePoint charOrHex = percentEncodedStream.next();
            if (!(charOrHex instanceof HexCodePoint ? !(hex = (HexCodePoint)charOrHex).isUpperCase() : charOrHex instanceof CodePoint && !(codePoint = (CodePoint)charOrHex).isIn(charactersThatDoNotNeedEncoding))) continue;
            return false;
        }
        return true;
    }

    static boolean isNormalForm(String original, boolean[] charactersThatDoNotNeedEncoding, boolean[] charactersToLeaveAsIs) {
        PercentEncodedStream percentEncodedStream = new PercentEncodedStream(original);
        while (percentEncodedStream.hasNext()) {
            CodePoint character;
            CodePointOrHexCodePoint charOrHex = percentEncodedStream.next();
            if (charOrHex instanceof HexCodePoint) {
                HexCodePoint hex = (HexCodePoint)charOrHex;
                if (!hex.isUpperCase()) {
                    return false;
                }
                CodePoint decodedChar = hex.decode();
                if (!decodedChar.isIn(charactersThatDoNotNeedEncoding) || decodedChar.isIn(charactersToLeaveAsIs)) continue;
                return false;
            }
            if (!(charOrHex instanceof CodePoint) || (character = (CodePoint)charOrHex).isIn(charactersThatDoNotNeedEncoding) || character.isIn(charactersToLeaveAsIs)) continue;
            return false;
        }
        return true;
    }

    static boolean isNormalForm(String original, boolean[] charactersThatDoNotNeedEncoding) {
        return PercentEncoding.isNormalForm(original, charactersThatDoNotNeedEncoding, Constants.empty);
    }

    static String encode(String unencoded, boolean[] charactersThatDoNotNeedEncoding) {
        AppendableToAwareStringBuilder result = new AppendableToAwareStringBuilder();
        new CodePointStream(unencoded).forEachRemaining(codePoint -> result.append(codePoint.maybePercentEncode(charactersThatDoNotNeedEncoding)));
        return result.toString();
    }
}

