/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.jspecify.annotations.Nullable;
import org.wiremock.url.CodePoint;
import org.wiremock.url.CodePointOrHexCodePoint;
import org.wiremock.url.HexCharacter;
import org.wiremock.url.HexSequence;
import org.wiremock.url.StringTokenStream;

class PercentEncodedStream
extends StringTokenStream<CodePointOrHexCodePoint> {
    PercentEncodedStream(String input) {
        super(input);
    }

    @Override
    public CodePointOrHexCodePoint next() {
        HexCharacter maybeHex = this.nextHex(this.index);
        if (maybeHex != null) {
            int decodedChar = maybeHex.decode().codePoint();
            int firstByte = decodedChar & 0xFF;
            int utf8Length = PercentEncodedStream.getUtf8SequenceLength(firstByte);
            if (utf8Length == 1) {
                this.index += 3;
                return maybeHex;
            }
            HexCharacter[] hexChars = new HexCharacter[utf8Length];
            hexChars[0] = maybeHex;
            for (int i = 1; i < utf8Length; ++i) {
                HexCharacter continuationHex = this.nextHex(this.index + i * 3);
                if (continuationHex == null) {
                    this.index += 3;
                    return maybeHex;
                }
                hexChars[i] = continuationHex;
            }
            this.index += utf8Length * 3;
            return new HexSequence(hexChars);
        }
        int codePoint = this.input.codePointAt(this.index);
        this.index += Character.charCount(codePoint);
        return new CodePoint(codePoint);
    }

    private static int getUtf8SequenceLength(int firstByte) {
        if ((firstByte & 0x80) == 0) {
            return 1;
        }
        if ((firstByte & 0xE0) == 192) {
            return 2;
        }
        if ((firstByte & 0xF0) == 224) {
            return 3;
        }
        if ((firstByte & 0xF8) == 240) {
            return 4;
        }
        return 1;
    }

    private @Nullable HexCharacter nextHex(int startPoint) {
        if (startPoint >= this.input.length()) {
            return null;
        }
        char startChar = this.input.charAt(startPoint);
        if (startChar == '%' && startPoint + 2 < this.input.length()) {
            char maybeFirstHexDigit = this.input.charAt(startPoint + 1);
            char maybeSecondHexDigit = this.input.charAt(startPoint + 2);
            if (PercentEncodedStream.isHexDigit(maybeFirstHexDigit) && PercentEncodedStream.isHexDigit(maybeSecondHexDigit)) {
                return new HexCharacter(maybeFirstHexDigit, maybeSecondHexDigit);
            }
        }
        return null;
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }
}

