/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wiremock.stringparser.StringParser;
import org.wiremock.url.IllegalPathAndQuery;
import org.wiremock.url.IllegalUri;
import org.wiremock.url.IllegalUriPart;
import org.wiremock.url.Path;
import org.wiremock.url.PathAndQuery;
import org.wiremock.url.PathParser;
import org.wiremock.url.Query;

public final class PathAndQueryParser
implements StringParser<PathAndQuery> {
    public static final PathAndQueryParser INSTANCE = new PathAndQueryParser();
    private static final Pattern regex = Pattern.compile("^(?<path>/[^?#]*|)(?:\\?(?<query>[^#]*))?$");

    public Class<PathAndQuery> getType() {
        return PathAndQuery.class;
    }

    public PathAndQuery parse(String stringForm) {
        try {
            Matcher result = regex.matcher(stringForm);
            if (!result.matches()) {
                throw new IllegalPathAndQuery(stringForm);
            }
            Path path = PathParser.INSTANCE.parse(result.group("path"));
            String queryString = result.group("query");
            Query query = queryString == null ? null : Query.parse(queryString);
            return PathAndQuery.of(path, query);
        }
        catch (IllegalUriPart illegalPart) {
            throw new IllegalUri(stringForm, illegalPart);
        }
    }
}

