/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wiremock.stringparser.ParsedString;
import org.wiremock.url.IllegalPath;
import org.wiremock.url.PathParser;
import org.wiremock.url.PathValue;
import org.wiremock.url.PercentEncoded;
import org.wiremock.url.Segment;

public interface Path
extends PercentEncoded<Path>,
ParsedString {
    public static final Path EMPTY = new PathValue("", true);
    public static final Path ROOT = new PathValue("/", true);

    public boolean isAbsolute();

    default public boolean isRelative() {
        return !this.isAbsolute();
    }

    default public boolean isBase() {
        return this.isEmpty() || this.getLastSegment().isEmpty();
    }

    default public boolean isLeaf() {
        return !this.isBase();
    }

    public List<Segment> getSegments();

    default public Segment getFirstSegment() {
        return this.getSegments().get(0);
    }

    default public Segment getLastSegment() {
        List<Segment> segments = this.getSegments();
        return segments.get(segments.size() - 1);
    }

    @Override
    public Path normalise();

    public Path resolve(Path var1);

    @Override
    default public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    default public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return Path.parse("/" + String.valueOf(this));
    }

    default public Path toRelativePath() {
        if (this.isRelative()) {
            return this;
        }
        String pathStr = this.toString();
        return Path.parse(pathStr.substring(1));
    }

    default public Path toBasePath() {
        if (this.isBase()) {
            return this;
        }
        return Path.parse(String.valueOf(this) + "/");
    }

    default public Path toLeafPath() {
        if (this.isEmpty() || this.isLeaf()) {
            return this;
        }
        String pathStr = this.toString();
        return Path.parse(pathStr.substring(0, pathStr.length() - 1));
    }

    public static Path parse(String path) throws IllegalPath {
        return PathParser.INSTANCE.parse(path);
    }

    public static Path encode(String unencoded) {
        return PathParser.INSTANCE.encode(unencoded);
    }

    public static Path of(List<Segment> segments) {
        return Path.of(segments.stream());
    }

    public static Path of(Stream<Segment> segments) {
        return new PathValue(segments.map(Object::toString).collect(Collectors.joining("/")));
    }

    default public Path removePrefix(Path prefix) {
        String prefixStr;
        if (prefix.isEmpty()) {
            return this;
        }
        String pathStr = this.toString();
        if (pathStr.startsWith(prefixStr = prefix.toString())) {
            return Path.parse(pathStr.substring(prefixStr.length()));
        }
        return this;
    }

    default public Path append(Path toAppend) {
        if (this.isEmpty()) {
            return toAppend;
        }
        if (toAppend.isEmpty()) {
            return this;
        }
        return Path.parse(this.toLeafPath().toString() + String.valueOf(toAppend.toAbsolutePath()));
    }
}

