/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.wiremock.url.Password;
import org.wiremock.url.PercentEncoding;
import org.wiremock.url.UserInfoParser;

final class PasswordValue
implements Password {
    private final String password;
    private final boolean isNormalForm;

    PasswordValue(String password) {
        this(password, false);
    }

    PasswordValue(String password, boolean isNormalForm) {
        this.password = password;
        this.isNormalForm = isNormalForm;
    }

    @Override
    public Password normalise() {
        if (this.isNormalForm) {
            return this;
        }
        String result = PercentEncoding.normalise(this.password, UserInfoParser.userInfoCharSet);
        if (result == null) {
            return this;
        }
        return new PasswordValue(result, true);
    }

    @Override
    public boolean isNormalForm() {
        return this.isNormalForm || PercentEncoding.isNormalForm(this.password, UserInfoParser.userInfoCharSet);
    }

    public String toString() {
        return this.password;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Password) {
            Password that = (Password)obj;
            return Objects.equals(this.toString(), that.toString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.password);
    }
}

