/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbsoluteUri;
import org.wiremock.url.Authority;
import org.wiremock.url.Fragment;
import org.wiremock.url.Host;
import org.wiremock.url.IllegalOpaqueUri;
import org.wiremock.url.OpaqueUriParser;
import org.wiremock.url.OpaqueUriValue;
import org.wiremock.url.Path;
import org.wiremock.url.Port;
import org.wiremock.url.Query;
import org.wiremock.url.Scheme;
import org.wiremock.url.UserInfo;

public interface OpaqueUri
extends AbsoluteUri {
    @Override
    default public boolean isAbsoluteUrl() {
        return false;
    }

    @Override
    default public boolean isOpaqueUri() {
        return true;
    }

    @Override
    @Deprecated
    default public @Nullable Authority getAuthority() {
        return null;
    }

    @Override
    @Deprecated
    default public @Nullable UserInfo getUserInfo() {
        return null;
    }

    @Override
    @Deprecated
    default public @Nullable Host getHost() {
        return null;
    }

    @Override
    @Deprecated
    default public @Nullable Port getPort() {
        return null;
    }

    @Override
    @Deprecated
    default public @Nullable Port getResolvedPort() {
        return null;
    }

    public static OpaqueUri parse(String opaqueUri) throws IllegalOpaqueUri {
        return OpaqueUriParser.INSTANCE.parse(opaqueUri);
    }

    public static OpaqueUri of(Scheme scheme, Path path) {
        return OpaqueUri.of(scheme, path, null, null);
    }

    public static OpaqueUri of(Scheme scheme, Path path, Query query) {
        return OpaqueUri.of(scheme, path, query, null);
    }

    public static OpaqueUri of(Scheme scheme, Path path, @Nullable Query query, @Nullable Fragment fragment) {
        return new OpaqueUriValue(scheme, path, query, fragment);
    }
}

