/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.wiremock.url.CodePoint;
import org.wiremock.url.CodePointOrHexCodePoint;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface HexCodePoint
extends CodePointOrHexCodePoint {
    @Override
    public CodePoint decode();

    @Override
    default public boolean isEncoded() {
        return true;
    }

    public HexCodePoint toUpperCase();

    public boolean isUpperCase();

    public static int hexDigitToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hex digit: " + c);
    }
}

