/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.wiremock.url.CodePoint;
import org.wiremock.url.HexCodePoint;

record HexCharacter(char digit1, char digit2) implements HexCodePoint
{
    @Override
    public CodePoint decode() {
        return new CodePoint((char)(HexCodePoint.hexDigitToInt(this.digit1) << 4 | HexCodePoint.hexDigitToInt(this.digit2)));
    }

    @Override
    public HexCharacter toUpperCase() {
        char char1Upper = Character.toUpperCase(this.digit1);
        char char2Upper = Character.toUpperCase(this.digit2);
        if (char1Upper == this.digit1 && char2Upper == this.digit2) {
            return this;
        }
        return new HexCharacter(char1Upper, char2Upper);
    }

    @Override
    public boolean isUpperCase() {
        return HexCharacter.isUpperCaseHexDigit(this.digit1) && HexCharacter.isUpperCaseHexDigit(this.digit2);
    }

    @Override
    public String toString() {
        return new String(new char[]{'%', this.digit1, this.digit2});
    }

    @Override
    public void appendTo(StringBuilder builder) {
        builder.append('%').append(this.digit1).append(this.digit2);
    }

    private static boolean isUpperCaseHexDigit(char c) {
        return Character.isUpperCase(c) || Character.isDigit(c);
    }
}

