/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.wiremock.url.Constants;
import org.wiremock.url.Fragment;
import org.wiremock.url.FragmentValue;
import org.wiremock.url.PercentEncodedStringParser;
import org.wiremock.url.PercentEncoding;

public final class FragmentParser
implements PercentEncodedStringParser<Fragment> {
    public static final FragmentParser INSTANCE = new FragmentParser();
    static final boolean[] fragmentCharSet = Constants.combine(Constants.pcharCharSet, new boolean[][]{Constants.include('/', '?')});

    public Class<Fragment> getType() {
        return Fragment.class;
    }

    public Fragment parse(String stringForm) {
        if (stringForm.isEmpty()) {
            return Fragment.EMPTY;
        }
        return new FragmentValue(stringForm);
    }

    @Override
    public Fragment encode(String unencoded) {
        if (unencoded.isEmpty()) {
            return Fragment.EMPTY;
        }
        String result = PercentEncoding.encode(unencoded, fragmentCharSet);
        return new FragmentValue(result, true);
    }
}

