/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.IllegalScheme;
import org.wiremock.url.Port;
import org.wiremock.url.Scheme;
import org.wiremock.url.SchemeRegistry;
import org.wiremock.url.SchemeValue;

public final class DefaultSchemeRegistry
implements SchemeRegistry {
    static final Pattern schemeRegex = Pattern.compile("[a-zA-Z][a-zA-Z0-9+\\-.]{0,255}");
    private final Map<String, Scheme> knownSchemes = new ConcurrentHashMap<String, Scheme>();

    @Override
    public Scheme register(String schemeString, @Nullable Port defaultPort) throws IllegalScheme {
        if (!schemeRegex.matcher(schemeString).matches()) {
            throw new IllegalScheme(schemeString);
        }
        String canonicalSchemeString = schemeString.toLowerCase(Locale.ROOT);
        return this.knownSchemes.computeIfAbsent(canonicalSchemeString, key -> new SchemeValue((String)key, null, defaultPort));
    }

    public Scheme parse(String schemeString) throws IllegalScheme {
        Scheme canonicalScheme = this.getCanonicalScheme(schemeString);
        if (canonicalScheme.toString().equals(schemeString)) {
            return canonicalScheme;
        }
        return new SchemeValue(schemeString, canonicalScheme, null);
    }

    private Scheme getCanonicalScheme(String schemeString) throws IllegalScheme {
        String canonicalSchemeString = schemeString.toLowerCase(Locale.ROOT);
        Scheme existingCanonical = this.knownSchemes.get(canonicalSchemeString);
        if (existingCanonical != null) {
            return existingCanonical;
        }
        if (!schemeRegex.matcher(schemeString).matches()) {
            throw new IllegalScheme(schemeString);
        }
        return new SchemeValue(canonicalSchemeString, null, null);
    }
}

