/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.nio.charset.StandardCharsets;
import org.wiremock.url.CodePointOrHexCodePoint;
import org.wiremock.url.HexCharacter;
import org.wiremock.url.HexCodePoint;
import org.wiremock.url.HexSequence;

record CodePoint(int codePoint) implements CodePointOrHexCodePoint
{
    @Override
    public boolean isEncoded() {
        return false;
    }

    public CodePointOrHexCodePoint maybePercentEncode(boolean[] charactersThatDoNotNeedEncoding) {
        if (this.isIn(charactersThatDoNotNeedEncoding)) {
            return this;
        }
        return this.percentEncode();
    }

    private HexCodePoint percentEncode() {
        int codePoint = this.codePoint();
        String str = new String(Character.toChars(codePoint));
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        HexCharacter[] hexCharacters = new HexCharacter[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            hexCharacters[i] = CodePoint.getHexCharacter(bytes[i]);
        }
        return new HexSequence(hexCharacters);
    }

    private static HexCharacter getHexCharacter(byte aByte) {
        int byteValue = aByte & 0xFF;
        return new HexCharacter(CodePoint.toHexDigit(byteValue >> 4), CodePoint.toHexDigit(byteValue & 0xF));
    }

    static char toHexDigit(int value) {
        return (char)(value < 10 ? 48 + value : 65 + value - 10);
    }

    public boolean isIn(boolean[] charactersThatDoNotNeedEncoding) {
        return this.codePoint < charactersThatDoNotNeedEncoding.length && charactersThatDoNotNeedEncoding[this.codePoint];
    }

    @Override
    public String toString() {
        return new String(Character.toChars(this.codePoint));
    }

    @Override
    public CodePoint decode() {
        return this;
    }

    @Override
    public void appendTo(StringBuilder builder) {
        builder.appendCodePoint(this.codePoint);
    }
}

