/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.Authority;
import org.wiremock.url.Host;
import org.wiremock.url.HostAndPort;
import org.wiremock.url.Lazy;
import org.wiremock.url.Port;
import org.wiremock.url.Scheme;
import org.wiremock.url.UserInfo;

final class AuthorityValue
implements Authority {
    private final @Nullable UserInfo userInfo;
    private final Host host;
    private final @Nullable Optional<Port> maybePort;
    private final Lazy<String> toString;

    AuthorityValue(@Nullable UserInfo userInfo, Host host, @Nullable Optional<Port> maybePort) {
        this(null, userInfo, host, maybePort);
    }

    AuthorityValue(@Nullable String stringValue, @Nullable UserInfo userInfo, Host host, @Nullable Optional<Port> maybePort) {
        this.toString = Lazy.lazy(stringValue, this::buildString);
        this.userInfo = userInfo;
        this.host = Objects.requireNonNull(host);
        this.maybePort = maybePort;
    }

    @Override
    public @Nullable Port getPort() {
        return this.maybePort != null ? (Port)this.maybePort.orElse(null) : null;
    }

    @Override
    public @Nullable Optional<Port> getMaybePort() {
        return this.maybePort;
    }

    public String toString() {
        return this.toString.get();
    }

    private String buildString() {
        StringBuilder result = new StringBuilder();
        if (this.userInfo != null) {
            result.append(this.userInfo).append('@');
        }
        result.append(this.host);
        if (this.maybePort != null) {
            result.append(':');
            this.maybePort.ifPresent(result::append);
        }
        return result.toString();
    }

    @Override
    public HostAndPort getHostAndPort() {
        return HostAndPort.of(this.host, this.getPort());
    }

    @Override
    public Authority withPort(@Nullable Port port) {
        Optional<Port> newPort;
        Optional<Port> optional = newPort = port != null ? Optional.of(port) : null;
        if (Objects.equals(newPort, this.maybePort)) {
            return this;
        }
        return new AuthorityValue(this.userInfo, this.host, newPort);
    }

    @Override
    public Authority normalise() {
        Port normalisedPort = this.normalisePort();
        return this.buildNormalisedAuthority(normalisedPort);
    }

    @Override
    public Authority normalise(Scheme canonicalScheme) {
        Port normalisedPort = this.normalisePort(canonicalScheme);
        return this.buildNormalisedAuthority(normalisedPort);
    }

    private @Nullable Port normalisePort(Scheme canonicalScheme) {
        Port normalisedPort = this.normalisePort();
        return Objects.equals(normalisedPort, canonicalScheme.getDefaultPort()) ? null : normalisedPort;
    }

    private @Nullable Port normalisePort() {
        Port port = this.getPort();
        return port != null ? port.normalise() : null;
    }

    private Authority buildNormalisedAuthority(@Nullable Port normalisedPort) {
        Optional<Port> optionalNormalisedPort;
        UserInfo normalisedUserInfo = this.userInfo != null ? (UserInfo)this.userInfo.normalise() : null;
        Host normalisedHost = this.host.normalise();
        Optional<Port> optional = optionalNormalisedPort = normalisedPort != null ? Optional.of(normalisedPort) : null;
        if (Objects.equals(normalisedUserInfo, this.userInfo) && normalisedHost.equals(this.host) && Objects.equals(optionalNormalisedPort, this.maybePort)) {
            return this;
        }
        if (normalisedUserInfo == null) {
            return HostAndPort.of(normalisedHost, normalisedPort);
        }
        return new AuthorityValue(normalisedUserInfo, normalisedHost, optionalNormalisedPort);
    }

    @Override
    public @Nullable UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    public boolean equals(Object other) {
        return Authority.equals(this, other);
    }

    public int hashCode() {
        return Authority.hashCode(this);
    }
}

