/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.wiremock.stringparser.ParsedString;
import org.wiremock.url.AuthorityParser;
import org.wiremock.url.Host;
import org.wiremock.url.HostAndPort;
import org.wiremock.url.IllegalAuthority;
import org.wiremock.url.Normalisable;
import org.wiremock.url.Port;
import org.wiremock.url.Scheme;
import org.wiremock.url.UserInfo;

public interface Authority
extends Normalisable<Authority>,
ParsedString {
    public @Nullable UserInfo getUserInfo();

    public Host getHost();

    public @Nullable Port getPort();

    public @Nullable Optional<Port> getMaybePort();

    public HostAndPort getHostAndPort();

    public Authority withPort(@Nullable Port var1);

    default public Authority withoutPort() {
        return this.withPort(null);
    }

    public Authority normalise(Scheme var1);

    @Override
    default public boolean isNormalForm() {
        Optional<Port> maybePort = this.getMaybePort();
        return (this.getUserInfo() == null || this.getUserInfo().isNormalForm()) && this.getHost().isNormalForm() && (maybePort == null || maybePort.isPresent() && maybePort.get().isNormalForm());
    }

    default public boolean isNormalForm(Scheme canonicalScheme) {
        return this.getHost().isNormalForm() && this.portIsNormalForm(canonicalScheme);
    }

    private boolean portIsNormalForm(Scheme scheme) {
        Optional<Port> maybePort = this.getMaybePort();
        return maybePort == null || maybePort.isPresent() && maybePort.get().isNormalForm() && !maybePort.get().equals(scheme.getDefaultPort());
    }

    public static Authority parse(String authorityStr) throws IllegalAuthority {
        return AuthorityParser.INSTANCE.parse(authorityStr);
    }

    public static Authority of(Host host) {
        return Authority.of(null, host, null);
    }

    public static Authority of(Host host, @Nullable Port port) {
        return Authority.of(null, host, port);
    }

    public static Authority of(@Nullable UserInfo userInfo, Host host) {
        return Authority.of(userInfo, host, null);
    }

    public static Authority of(@Nullable UserInfo userInfo, Host host, @Nullable Port port) {
        return AuthorityParser.INSTANCE.of(userInfo, host, port);
    }

    public static boolean equals(Authority one, Object o) {
        if (one == o) {
            return true;
        }
        if (!(o instanceof Authority)) {
            return false;
        }
        Authority other = (Authority)o;
        return Objects.equals(one.getUserInfo(), other.getUserInfo()) && Objects.equals(one.getHost(), other.getHost()) && Objects.equals(one.getMaybePort(), other.getMaybePort());
    }

    public static int hashCode(Authority authority) {
        return Objects.hash(authority.getUserInfo(), authority.getHost(), authority.getMaybePort());
    }
}

