/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbsoluteUrl;
import org.wiremock.url.Authority;
import org.wiremock.url.BaseUrl;
import org.wiremock.url.Fragment;
import org.wiremock.url.Lazy;
import org.wiremock.url.OpaqueUri;
import org.wiremock.url.Origin;
import org.wiremock.url.Path;
import org.wiremock.url.PathAndQuery;
import org.wiremock.url.Query;
import org.wiremock.url.RelativeUrl;
import org.wiremock.url.Scheme;
import org.wiremock.url.SchemeRelativeUrl;
import org.wiremock.url.ServersideAbsoluteUrl;
import org.wiremock.url.Uri;

abstract class AbstractUriValue
implements Uri {
    protected final @Nullable Scheme scheme;
    protected final @Nullable Authority authority;
    protected final Path path;
    protected final @Nullable Query query;
    protected final @Nullable Fragment fragment;
    private final Lazy<String> toString;
    private static final List<Class<? extends Uri>> URI_TYPES = List.of(Origin.class, BaseUrl.class, ServersideAbsoluteUrl.class, AbsoluteUrl.class, OpaqueUri.class, SchemeRelativeUrl.class, RelativeUrl.class, PathAndQuery.class);

    AbstractUriValue(@Nullable String stringValue, @Nullable Scheme scheme, @Nullable Authority authority, Path path, @Nullable Query query, @Nullable Fragment fragment) {
        this.toString = Lazy.lazy(stringValue, this::buildString);
        this.scheme = scheme;
        this.authority = authority;
        this.path = Objects.requireNonNull(path);
        this.query = query;
        this.fragment = fragment;
    }

    @Override
    public @Nullable Scheme getScheme() {
        return this.scheme;
    }

    @Override
    public @Nullable Authority getAuthority() {
        return this.authority;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public @Nullable Query getQuery() {
        return this.query;
    }

    @Override
    public @Nullable Fragment getFragment() {
        return this.fragment;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Uri)) {
            return false;
        }
        Uri other = (Uri)obj;
        Class<?> oneClass = this.getClass();
        Class<?> otherClass = other.getClass();
        return AbstractUriValue.shareSameSuperTypes(oneClass, otherClass, URI_TYPES) && Objects.equals(this.getScheme(), other.getScheme()) && Objects.equals(this.getAuthority(), other.getAuthority()) && Objects.equals(this.getPath(), other.getPath()) && Objects.equals(this.getQuery(), other.getQuery()) && Objects.equals(this.getFragment(), other.getFragment());
    }

    private static <T> boolean shareSameSuperTypes(Class<? extends T> oneClass, Class<? extends T> otherClass, List<Class<? extends T>> types) {
        for (Class<T> clazz : types) {
            if (oneClass.isAssignableFrom(clazz) == otherClass.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.getScheme(), this.getAuthority(), this.getPath(), this.query, this.getFragment());
    }

    public String toString() {
        return this.toString.get();
    }

    private String buildString() {
        StringBuilder result = new StringBuilder();
        if (this.getScheme() != null) {
            result.append(this.getScheme()).append(":");
        }
        if (this.getAuthority() != null) {
            result.append("//").append(this.getAuthority());
        }
        result.append(this.getPath());
        if (this.query != null) {
            result.append("?").append(this.query);
        }
        if (this.getFragment() != null) {
            result.append("#").append(this.getFragment());
        }
        return result.toString();
    }
}

