/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbsoluteUrl;
import org.wiremock.url.AbstractAbsoluteUriValue;
import org.wiremock.url.Authority;
import org.wiremock.url.Fragment;
import org.wiremock.url.IllegalAbsoluteUrl;
import org.wiremock.url.IllegalPath;
import org.wiremock.url.Path;
import org.wiremock.url.Query;
import org.wiremock.url.Scheme;

abstract class AbstractAbsoluteUrlValue<NORMALISED extends AbsoluteUrl>
extends AbstractAbsoluteUriValue<NORMALISED>
implements AbsoluteUrl {
    protected final Authority nonNullAuthority;

    AbstractAbsoluteUrlValue(@Nullable String stringValue, Scheme scheme, Authority authority, Path path, @Nullable Query query, @Nullable Fragment fragment) {
        super(stringValue, scheme, authority, path, query, fragment);
        this.nonNullAuthority = Objects.requireNonNull(authority);
        if (!path.isEmpty() && !path.isAbsolute()) {
            throw new IllegalAbsoluteUrl(this.toString(), "Illegal absolute url: `" + String.valueOf(this) + "` - an absolute url's path must be absolute or empty, was `" + String.valueOf(path) + "`", new IllegalPath(path.toString(), "Illegal path: `" + String.valueOf(path) + "` - must be absolute or empty"));
        }
    }

    @Override
    public Authority getAuthority() {
        return this.nonNullAuthority;
    }
}

