/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.function.Consumer;
import org.wiremock.url.AbsoluteUri;
import org.wiremock.url.AbsoluteUrlBuilder;
import org.wiremock.url.AbsoluteUrlParser;
import org.wiremock.url.AbsoluteUrlTransformer;
import org.wiremock.url.Authority;
import org.wiremock.url.BaseUrl;
import org.wiremock.url.Host;
import org.wiremock.url.IllegalAbsoluteUrl;
import org.wiremock.url.IllegalUrl;
import org.wiremock.url.Origin;
import org.wiremock.url.Path;
import org.wiremock.url.RelativeUrl;
import org.wiremock.url.Scheme;
import org.wiremock.url.SchemeRelativeUrl;
import org.wiremock.url.ServersideAbsoluteUrl;
import org.wiremock.url.Uri;
import org.wiremock.url.UriBaseBuilder;
import org.wiremock.url.Url;
import org.wiremock.url.UrlWithAuthority;

public interface AbsoluteUrl
extends AbsoluteUri,
UrlWithAuthority {
    @Override
    public Authority getAuthority();

    @Override
    default public boolean isRelative() {
        return false;
    }

    @Override
    default public boolean isAbsoluteUrl() {
        return true;
    }

    @Override
    default public boolean isOpaqueUri() {
        return false;
    }

    @Override
    default public Host getHost() {
        return this.getAuthority().getHost();
    }

    default public Origin getOrigin() {
        AbsoluteUrl normalised = this.normalise();
        return Origin.of(normalised.getScheme(), normalised.getAuthority().getHostAndPort());
    }

    default public ServersideAbsoluteUrl getServersideAbsoluteUrl() {
        return (ServersideAbsoluteUrl)this.transform((T builder) -> builder.setFragment(null));
    }

    default public BaseUrl toBaseUrl() {
        return (BaseUrl)this.transform((T builder) -> ((Uri.Transformer)((Uri.Transformer)builder.setPath(this.getPath().toBasePath())).setQuery(null)).setFragment(null));
    }

    @Override
    default public SchemeRelativeUrl getSchemeRelativeUrl() {
        return (SchemeRelativeUrl)Url.builder(this).setScheme(null).build();
    }

    @Override
    public AbsoluteUrl normalise();

    default public AbsoluteUrl resolve(String other) throws IllegalUrl {
        return this.resolve(Url.parse(other));
    }

    @Override
    default public AbsoluteUrl resolve(Path other) {
        RelativeUrl relative = ((RelativeUrl.Builder)RelativeUrl.builder().setPath(other)).build();
        return this.resolve(relative);
    }

    default public AbsoluteUrl resolve(Url other) {
        return (AbsoluteUrl)this.resolve((Uri)other);
    }

    default public Transformer thaw() {
        return new AbsoluteUrlTransformer(this);
    }

    @Override
    default public AbsoluteUrl transform(Consumer<Uri.Transformer<?>> mutator) {
        Transformer transformer = this.thaw();
        mutator.accept(transformer);
        return transformer.build();
    }

    public static AbsoluteUrl parse(String url) throws IllegalAbsoluteUrl {
        return AbsoluteUrlParser.INSTANCE.parse(url);
    }

    public static Builder builder(Scheme scheme, Authority authority) {
        return new AbsoluteUrlBuilder(scheme, authority);
    }

    public static Builder builder(AbsoluteUrl url) {
        return new AbsoluteUrlBuilder(url);
    }

    public static interface Transformer
    extends Url.Transformer<Transformer>,
    AbsoluteUri.Transformer<Transformer> {
        @Override
        public AbsoluteUrl build();
    }

    public static interface Builder
    extends UriBaseBuilder<Builder> {
        public Scheme getScheme();

        public Builder setScheme(Scheme var1);

        @Override
        public AbsoluteUrl build();
    }
}

