/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.stringparser.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.wiremock.stringparser.ParseException;
import org.wiremock.stringparser.ParsedString;
import org.wiremock.stringparser.StringParser;

public class ParsedStringDeserializer<T extends ParsedString>
extends JsonDeserializer<T> {
    private final StringParser<T> parser;

    public ParsedStringDeserializer(StringParser<T> parser) {
        this.parser = parser;
    }

    public StringParser<T> getStringParser() {
        return this.parser;
    }

    public @Nullable T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String text = p.getValueAsString();
        if (text == null) {
            return null;
        }
        try {
            return (T)this.parser.parse(text);
        }
        catch (ParseException e) {
            throw JsonMappingException.from((JsonParser)p, (String)e.getMessage(), (Throwable)e);
        }
    }
}

