/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.recording.ResponseDefinitionBodyMatcher;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.databind.DeserializationContext;
import wiremock.com.fasterxml.jackson.databind.JsonDeserializer;
import wiremock.com.fasterxml.jackson.databind.JsonNode;

public class ResponseDefinitionBodyMatcherDeserializer
extends JsonDeserializer<ResponseDefinitionBodyMatcher> {
    @Override
    public ResponseDefinitionBodyMatcher deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        return new ResponseDefinitionBodyMatcher(ResponseDefinitionBodyMatcherDeserializer.parseJsonNode(rootNode.get("textSizeThreshold")), ResponseDefinitionBodyMatcherDeserializer.parseJsonNode(rootNode.get("binarySizeThreshold")));
    }

    public static long parseJsonNode(JsonNode node) {
        if (node == null || node.isNull()) {
            return Long.MAX_VALUE;
        }
        if (node.isNumber()) {
            return node.asLong();
        }
        return ResponseDefinitionBodyMatcherDeserializer.parseFilesize(node.textValue());
    }

    public static long parseFilesize(String in) {
        String cleanedInput = in.trim().replaceAll(",", ".");
        Matcher m4 = Pattern.compile("^([\\d.]+)\\s*(\\w)?b?$", 2).matcher(cleanedInput);
        if (!m4.find()) {
            throw new IllegalArgumentException("Invalid size string: \"" + in + "\"");
        }
        int scale = 1;
        if (m4.group(2) != null) {
            switch (m4.group(2).toUpperCase()) {
                case "G": {
                    scale *= 1024;
                }
                case "M": {
                    scale *= 1024;
                }
                case "K": {
                    scale *= 1024;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid size unit: " + m4.group(2));
                }
            }
        }
        return Math.round(Double.parseDouble(m4.group(1)) * (double)scale);
    }
}

