/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.ErrorMessageType;
import wiremock.com.networknt.schema.Format;
import wiremock.com.networknt.schema.FormatValidator;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.Keyword;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidatorTypeCode;

public class FormatKeyword
implements Keyword {
    private final String value;
    private final ErrorMessageType errorMessageType;
    private final Map<String, Format> formats;

    public FormatKeyword(Map<String, Format> formats) {
        this(ValidatorTypeCode.FORMAT, formats);
    }

    public FormatKeyword(ValidatorTypeCode type, Map<String, Format> formats) {
        this(type.getValue(), type, formats);
    }

    public FormatKeyword(String value, ErrorMessageType errorMessageType, Map<String, Format> formats) {
        this.value = value;
        this.formats = formats;
        this.errorMessageType = errorMessageType;
    }

    Collection<Format> getFormats() {
        return Collections.unmodifiableCollection(this.formats.values());
    }

    @Override
    public JsonValidator newValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        Format format = null;
        if (schemaNode != null && schemaNode.isTextual()) {
            String formatName = schemaNode.textValue();
            format = this.formats.get(formatName);
        }
        return new FormatValidator(schemaLocation, evaluationPath, schemaNode, parentSchema, validationContext, format, this.errorMessageType, this);
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

