/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.ProhibitedNetworkAddressException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.stream.Stream;
import wiremock.org.apache.hc.client5.http.DnsResolver;
import wiremock.org.apache.hc.client5.http.SystemDefaultDnsResolver;

public class NetworkAddressRulesAdheringDnsResolver
implements DnsResolver {
    private final DnsResolver delegate;
    private final NetworkAddressRules networkAddressRules;

    public NetworkAddressRulesAdheringDnsResolver(NetworkAddressRules networkAddressRules) {
        this(SystemDefaultDnsResolver.INSTANCE, networkAddressRules);
    }

    public NetworkAddressRulesAdheringDnsResolver(DnsResolver delegate, NetworkAddressRules networkAddressRules) {
        this.delegate = delegate;
        this.networkAddressRules = networkAddressRules;
    }

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        if (!this.networkAddressRules.isAllowed(host)) {
            throw new ProhibitedNetworkAddressException();
        }
        InetAddress[] resolved = this.delegate.resolve(host);
        if (this.networkAddressRules.isAllowedAll()) {
            return resolved;
        }
        InetAddress[] resolvedIpv4 = (InetAddress[])Arrays.stream(resolved).filter(inetAddress -> inetAddress instanceof Inet4Address).toArray(InetAddress[]::new);
        if (Stream.of(resolvedIpv4).anyMatch(address -> !this.networkAddressRules.isAllowed(address.getHostAddress()))) {
            throw new ProhibitedNetworkAddressException();
        }
        return resolvedIpv4;
    }

    @Override
    public String resolveCanonicalHostname(String host) throws UnknownHostException {
        return this.delegate.resolveCanonicalHostname(host);
    }
}

