/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.FormatValidator;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonType;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.TypeFactory;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;

public interface Format {
    public String getName();

    default public String getMessageKey() {
        return "format";
    }

    @Deprecated
    default public String getErrorMessageDescription() {
        return "";
    }

    default public boolean matches(ExecutionContext executionContext, String value) {
        return true;
    }

    default public boolean matches(ExecutionContext executionContext, ValidationContext validationContext, String value) {
        return this.matches(executionContext, value);
    }

    default public boolean matches(ExecutionContext executionContext, ValidationContext validationContext, JsonNode value) {
        JsonType nodeType = TypeFactory.getValueNodeType(value, validationContext.getConfig());
        if (nodeType != JsonType.STRING) {
            return true;
        }
        return this.matches(executionContext, validationContext, value.textValue());
    }

    default public boolean matches(ExecutionContext executionContext, ValidationContext validationContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean assertionsEnabled, FormatValidator formatValidator) {
        return this.matches(executionContext, validationContext, node);
    }

    default public Set<ValidationMessage> validate(ExecutionContext executionContext, ValidationContext validationContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean assertionsEnabled, Supplier<MessageSourceValidationMessage.Builder> message, FormatValidator formatValidator) {
        if (assertionsEnabled && !this.matches(executionContext, validationContext, node, rootNode, instanceLocation, assertionsEnabled, formatValidator)) {
            return Collections.singleton(((MessageSourceValidationMessage.Builder)message.get().arguments(this.getName(), this.getErrorMessageDescription(), node.asText())).build());
        }
        return Collections.emptySet();
    }
}

