/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.ethlo.time.internal.token;

import java.text.ParsePosition;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import wiremock.com.ethlo.time.internal.util.ErrorUtil;
import wiremock.com.ethlo.time.token.DateTimeToken;

public class SeparatorsToken
implements DateTimeToken {
    private final char[] separators;

    public SeparatorsToken(char ... separators) {
        this.separators = separators;
    }

    @Override
    public int read(String text, ParsePosition parsePosition) {
        int index = parsePosition.getIndex();
        if (text.length() <= index) {
            ErrorUtil.raiseUnexpectedEndOfText(text, text.length());
        }
        char c = text.charAt(index);
        for (char sep : this.separators) {
            if (c != sep) continue;
            parsePosition.setIndex(index + 1);
            return 1;
        }
        throw new DateTimeParseException(String.format("Expected character %s at position %d, found %s: %s", Arrays.toString(this.separators), index + 1, Character.valueOf(text.charAt(index)), text), text, index);
    }

    public String toString() {
        return "separators: " + Arrays.toString(this.separators);
    }
}

