/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.webhooks;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.FixedDelayDistribution;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import wiremock.com.fasterxml.jackson.annotation.JsonAnyGetter;
import wiremock.com.fasterxml.jackson.annotation.JsonAnySetter;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;

public class WebhookDefinition {
    private String method;
    private String url;
    private List<HttpHeader> headers;
    private Body body = Body.none();
    private DelayDistribution delay;
    private Parameters parameters;

    public static WebhookDefinition from(Parameters parameters) {
        return new WebhookDefinition(parameters.getString("method", "GET"), parameters.getString("url"), WebhookDefinition.toHttpHeaders(parameters.getMetadata("headers", null)), parameters.getString("body", null), parameters.getString("base64Body", null), WebhookDefinition.getDelayDistribution(parameters.getMetadata("delay", null)), parameters);
    }

    private static HttpHeaders toHttpHeaders(Metadata headerMap) {
        if (headerMap == null || headerMap.isEmpty()) {
            return null;
        }
        return new HttpHeaders(headerMap.entrySet().stream().map(entry -> new HttpHeader((String)entry.getKey(), WebhookDefinition.getHeaderValues(entry.getValue()))).collect(Collectors.toList()));
    }

    private static Collection<String> getHeaderValues(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        return Collections.singletonList(obj.toString());
    }

    private static DelayDistribution getDelayDistribution(Metadata delayParams) {
        if (delayParams == null) {
            return null;
        }
        return delayParams.as(DelayDistribution.class);
    }

    @JsonCreator
    public WebhookDefinition(String method, String url, HttpHeaders headers, String body, String base64Body, DelayDistribution delay, Parameters parameters) {
        this.method = method;
        this.url = url;
        ArrayList<HttpHeader> arrayList = this.headers = headers != null ? new ArrayList<HttpHeader>(headers.all()) : null;
        if (body != null) {
            this.body = new Body(body);
        } else if (base64Body != null) {
            this.body = new Body(Encoding.decodeBase64(base64Body));
        }
        this.delay = delay;
        this.parameters = parameters;
    }

    public WebhookDefinition() {
    }

    public String getMethod() {
        return this.method;
    }

    @JsonIgnore
    public RequestMethod getRequestMethod() {
        return RequestMethod.fromString(this.method);
    }

    public String getUrl() {
        return this.url;
    }

    public HttpHeaders getHeaders() {
        return new HttpHeaders(this.headers);
    }

    public String getBase64Body() {
        return this.body.isBinary() ? this.body.asBase64() : null;
    }

    public String getBody() {
        return this.body.isBinary() ? null : this.body.asString();
    }

    public DelayDistribution getDelay() {
        return this.delay;
    }

    @JsonIgnore
    public long getDelaySampleMillis() {
        return this.delay != null ? this.delay.sampleMillis() : 0L;
    }

    @JsonIgnore
    public Parameters getExtraParameters() {
        return this.parameters;
    }

    @JsonIgnore
    public byte[] getBinaryBody() {
        return this.body.asBytes();
    }

    public WebhookDefinition withMethod(String method) {
        this.method = method;
        return this;
    }

    public WebhookDefinition withMethod(RequestMethod method) {
        this.method = method.getName();
        return this;
    }

    public WebhookDefinition withUrl(URI url) {
        this.url = url.toString();
        return this;
    }

    public WebhookDefinition withUrl(String url) {
        this.url = url;
        return this;
    }

    public WebhookDefinition withHeaders(List<HttpHeader> headers) {
        this.headers = headers;
        return this;
    }

    public WebhookDefinition withHeader(String key, String ... values) {
        if (this.headers == null) {
            this.headers = new ArrayList<HttpHeader>();
        }
        this.headers.add(new HttpHeader(key, values));
        return this;
    }

    public WebhookDefinition withBody(String body) {
        this.body = new Body(body);
        return this;
    }

    public WebhookDefinition withBinaryBody(byte[] body) {
        this.body = new Body(body);
        return this;
    }

    public WebhookDefinition withFixedDelay(int delayMilliseconds) {
        this.delay = new FixedDelayDistribution(delayMilliseconds);
        return this;
    }

    public WebhookDefinition withDelay(DelayDistribution delay) {
        this.delay = delay;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getOtherFields() {
        return this.parameters;
    }

    @JsonAnySetter
    public WebhookDefinition withExtraParameter(String key, Object value) {
        if (this.parameters == null) {
            this.parameters = new Parameters();
        }
        this.parameters.put(key, value);
        return this;
    }

    @JsonIgnore
    public boolean hasBody() {
        return this.body != null && this.body.isPresent();
    }
}

