/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HelperUtils;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.jayway.jsonpath.DocumentContext;
import wiremock.com.jayway.jsonpath.InvalidModificationException;
import wiremock.com.jayway.jsonpath.InvalidPathException;
import wiremock.com.jayway.jsonpath.JsonPath;
import wiremock.com.jayway.jsonpath.ParseContext;
import wiremock.com.jayway.jsonpath.PathNotFoundException;
import wiremock.com.jayway.jsonpath.Predicate;

class JsonRemoveHelper
extends HandlebarsHelper<Object> {
    private final ParseContext parseContext = JsonPath.using(HelperUtils.jsonPathConfig);

    JsonRemoveHelper() {
    }

    public String apply(Object inputJson, Options options) {
        DocumentContext jsonDocument;
        if (!(inputJson instanceof String)) {
            return this.handleError("Input JSON must be a string");
        }
        if (inputJson.equals("null")) {
            return (String)inputJson;
        }
        if (options.params.length != 1) {
            return this.handleError("A single JSONPath expression parameter must be supplied");
        }
        Object jsonPathString = options.param(0);
        if (!(jsonPathString instanceof String)) {
            return this.handleError("JSONPath parameter must be a string");
        }
        try {
            jsonDocument = this.parseContext.parse((String)inputJson);
        }
        catch (Exception e) {
            return this.handleError("Input JSON string is not valid JSON ('" + inputJson + "')", e);
        }
        try {
            if (((String)jsonPathString).isEmpty()) {
                throw new InvalidPathException("JSONPath expression is empty");
            }
            return jsonDocument.delete((String)jsonPathString, new Predicate[0]).jsonString();
        }
        catch (PathNotFoundException e) {
            return (String)inputJson;
        }
        catch (InvalidPathException e) {
            String message = "JSONPath parameter is not a valid JSONPath expression ('" + jsonPathString + "')";
            return this.handleError(message, e);
        }
        catch (InvalidModificationException e) {
            String message = "Delete operation cannot be applied to JSONPath expression ('" + jsonPathString + "')";
            return this.handleError(message, e);
        }
    }
}

