/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.ssl;

import java.util.ArrayList;
import java.util.List;
import wiremock.org.apache.hc.core5.http.NameValuePair;
import wiremock.org.apache.hc.core5.http.message.BasicNameValuePair;
import wiremock.org.apache.hc.core5.util.CharArrayBuffer;
import wiremock.org.apache.hc.core5.util.Tokenizer;

final class DistinguishedNameParser {
    public static final DistinguishedNameParser INSTANCE = new DistinguishedNameParser();
    private static final Tokenizer.Delimiter EQUAL_OR_COMMA_OR_PLUS = Tokenizer.delimiters('=', ',', '+');
    private static final Tokenizer.Delimiter COMMA_OR_PLUS = Tokenizer.delimiters(',', '+');
    private final Tokenizer tokenParser = new InternalTokenParser();

    private DistinguishedNameParser() {
    }

    private String parseToken(CharArrayBuffer buf, Tokenizer.Cursor cursor, Tokenizer.Delimiter delimiters) {
        return this.tokenParser.parseToken((CharSequence)buf, cursor, delimiters);
    }

    private String parseValue(CharArrayBuffer buf, Tokenizer.Cursor cursor, Tokenizer.Delimiter delimiters) {
        return this.tokenParser.parseValue((CharSequence)buf, cursor, delimiters);
    }

    private NameValuePair parseParameter(CharArrayBuffer buf, Tokenizer.Cursor cursor) {
        String name = this.parseToken(buf, cursor, EQUAL_OR_COMMA_OR_PLUS);
        if (cursor.atEnd()) {
            return new BasicNameValuePair(name, null);
        }
        char delim = buf.charAt(cursor.getPos());
        cursor.updatePos(cursor.getPos() + 1);
        if (delim == ',') {
            return new BasicNameValuePair(name, null);
        }
        String value = this.parseValue(buf, cursor, COMMA_OR_PLUS);
        if (!cursor.atEnd()) {
            cursor.updatePos(cursor.getPos() + 1);
        }
        return new BasicNameValuePair(name, value);
    }

    List<NameValuePair> parse(CharArrayBuffer buf, Tokenizer.Cursor cursor) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.tokenParser.skipWhiteSpace(buf, cursor);
        while (!cursor.atEnd()) {
            NameValuePair param = this.parseParameter(buf, cursor);
            params.add(param);
        }
        return params;
    }

    List<NameValuePair> parse(String s2) {
        if (s2 == null) {
            return null;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(s2.length());
        buffer.append(s2);
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, s2.length());
        return this.parse(buffer, cursor);
    }

    static class InternalTokenParser
    extends Tokenizer {
        InternalTokenParser() {
        }

        @Override
        public void copyUnquotedContent(CharSequence buf, Tokenizer.Cursor cursor, Tokenizer.Delimiter delimiters, StringBuilder dst) {
            int pos = cursor.getPos();
            int indexFrom = cursor.getPos();
            int indexTo = cursor.getUpperBound();
            boolean escaped = false;
            int i = indexFrom;
            while (i < indexTo) {
                char current = buf.charAt(i);
                if (escaped) {
                    dst.append(current);
                    escaped = false;
                } else {
                    if (delimiters != null && delimiters.test(current) || Tokenizer.isWhitespace(current) || current == '\"') break;
                    if (current == '\\') {
                        escaped = true;
                    } else {
                        dst.append(current);
                    }
                }
                ++i;
                ++pos;
            }
            cursor.updatePos(pos);
        }
    }
}

