/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.common.xml.XmlException;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.AbstractFormattingHelper;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FormatXmlHelper
extends AbstractFormattingHelper {
    private final DocumentBuilderFactory documentBuilderFactory = Xml.DEFAULT_DOCUMENT_BUILDER_FACTORY;
    private final TransformerFactory transformerFactory;

    @Override
    String getName() {
        return "formatXml";
    }

    @Override
    String getDataFormat() {
        return "XML";
    }

    public FormatXmlHelper() {
        TransformerFactory factory = TransformerFactory.newDefaultInstance();
        factory.setAttribute("indent-number", 2);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        this.transformerFactory = factory;
    }

    @Override
    protected String apply(String bodyText, AbstractFormattingHelper.Format format) {
        try {
            Document xml = this.read(bodyText);
            switch (format) {
                case pretty: {
                    return this.print(xml, "yes");
                }
                case compact: {
                    return this.print(xml, "no");
                }
            }
            throw new IllegalStateException();
        }
        catch (XmlException | IOException | ParserConfigurationException | TransformerException | SAXException e) {
            return this.handleError("Input is not valid XML", e);
        }
    }

    private Document read(String xml) throws ParserConfigurationException, IOException, SAXException {
        try {
            DocumentBuilder db = this.documentBuilderFactory.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(xml)));
            return this.removeBlankTextNodes(doc);
        }
        catch (SAXException e) {
            throw XmlException.fromSaxException(e);
        }
    }

    private <T extends Node> T removeBlankTextNodes(T node) {
        ArrayList<Node> toRemove = new ArrayList<Node>();
        if (!(node instanceof Attr)) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node child = node.getChildNodes().item(i);
                if (this.isBlankTextNode(child)) {
                    toRemove.add(child);
                    continue;
                }
                this.removeBlankTextNodes(child);
            }
            for (Node child : toRemove) {
                node.removeChild(child);
            }
        }
        return node;
    }

    private boolean isBlankTextNode(Node node) {
        return node instanceof Text && node.getNodeValue().isBlank();
    }

    private String print(Document doc, String indent) throws TransformerException {
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", indent);
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        return this.writeToString(doc, transformer);
    }

    private String writeToString(Document doc, Transformer transformer) throws TransformerException {
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.toString();
    }
}

