/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty.websocket;

import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.websocket.WebSocketSession;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;

public class JettyWebSocketSession
implements WebSocketSession {
    private final Session session;

    public JettyWebSocketSession(Session session) {
        this.session = session;
    }

    public boolean isOpen() {
        return this.session != null && this.session.isOpen();
    }

    public void sendMessage(Message message) {
        if (this.isOpen()) {
            byte[] data = message.getBody().getData();
            if (message.isBinary()) {
                this.session.sendBinary(ByteBuffer.wrap(data), Callback.NOOP);
            } else {
                String text = new String(data, StandardCharsets.UTF_8);
                this.session.sendText(text, Callback.NOOP);
            }
        }
    }

    public void close() {
        if (this.isOpen()) {
            this.session.close(1000, "Closed by server", Callback.NOOP);
        }
    }

    public Session getJettySession() {
        return this.session;
    }
}

