/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import org.eclipse.jetty.ee11.servlet.Dispatcher;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.ServletContextRequest;
import org.eclipse.jetty.ee11.servlet.ServletContextResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.Callback;

public class NotFoundHandler
extends ErrorHandler {
    private final ErrorHandler DEFAULT_HANDLER = new ErrorHandler();
    private final ServletContextHandler adminServiceHandler;

    public NotFoundHandler(ServletContextHandler adminServiceHandler) {
        this.adminServiceHandler = adminServiceHandler;
    }

    public boolean errorPageForMethod(String method) {
        return true;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (response.getStatus() == 404) {
            Dispatcher requestDispatcher = (Dispatcher)this.adminServiceHandler.getServletContext().getRequestDispatcher("/not-matched");
            try {
                requestDispatcher.error((ServletRequest)((ServletContextRequest)request).getServletApiRequest(), (ServletResponse)((ServletContextResponse)response).getServletApiResponse());
                callback.succeeded();
                return true;
            }
            catch (ServletException e) {
                callback.failed((Throwable)e);
            }
        } else {
            try {
                return this.DEFAULT_HANDLER.handle(request, response, callback);
            }
            catch (Exception e) {
                callback.failed((Throwable)e);
            }
        }
        return false;
    }
}

