/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.github.tomakehurst.wiremock.common.entity.EntityDefinition;
import com.github.tomakehurst.wiremock.common.entity.TextEntityDefinition;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.message.ChannelTarget;
import com.github.tomakehurst.wiremock.message.MessageDefinition;
import com.github.tomakehurst.wiremock.message.OriginatingChannelTarget;
import com.github.tomakehurst.wiremock.message.RequestInitiatedChannelTarget;
import com.github.tomakehurst.wiremock.message.SendMessageAction;
import java.util.ArrayList;
import java.util.List;

public class SendMessageActionBuilder {
    private TextEntityDefinition.Builder textEntityBuilder = TextEntityDefinition.aTextMessage();
    private final List<String> transformers = new ArrayList<String>();
    private Parameters transformerParameters = Parameters.empty();

    public SendMessageActionBuilder withBody(String message) {
        this.textEntityBuilder.withBody(message);
        return this;
    }

    public SendMessageActionBuilder withBody(Object data) {
        this.textEntityBuilder.withBody(data);
        return this;
    }

    public SendMessageActionBuilder withBodyFromStore(String storeName, String key) {
        this.textEntityBuilder.withDataStore(storeName);
        this.textEntityBuilder.withDataRef(key);
        return this;
    }

    public SendMessageActionBuilder withBodyFromFile(String filePath) {
        this.textEntityBuilder.withFilePath(filePath);
        return this;
    }

    public SendMessageActionBuilder withTransformer(String transformerName) {
        this.transformers.add(transformerName);
        return this;
    }

    public SendMessageActionBuilder withTransformers(String ... transformerNames) {
        for (String name : transformerNames) {
            this.transformers.add(name);
        }
        return this;
    }

    public SendMessageActionBuilder withTransformerParameters(Parameters parameters) {
        this.transformerParameters = parameters;
        return this;
    }

    public SendMessageActionBuilder withTransformerParameter(String key, Object value) {
        this.transformerParameters = this.transformerParameters.merge(Parameters.one(key, value));
        return this;
    }

    private EntityDefinition resolveBody() {
        return this.textEntityBuilder.build();
    }

    public SendMessageAction onOriginatingChannel() {
        return new SendMessageAction(new MessageDefinition(this.resolveBody()), OriginatingChannelTarget.INSTANCE, this.transformers, this.transformerParameters);
    }

    public SendMessageAction onChannelsMatching(RequestPattern targetChannelPattern) {
        return new SendMessageAction(new MessageDefinition(this.resolveBody()), RequestInitiatedChannelTarget.forPattern(targetChannelPattern), this.transformers, this.transformerParameters);
    }

    public SendMessageAction onChannelsMatching(RequestPatternBuilder targetChannelPatternBuilder) {
        return this.onChannelsMatching(targetChannelPatternBuilder.build());
    }

    public TargetedSendMessageActionBuilder toOriginatingChannel() {
        return new TargetedSendMessageActionBuilder(OriginatingChannelTarget.INSTANCE, this.transformers, this.transformerParameters);
    }

    public TargetedSendMessageActionBuilder toMatchingChannels(RequestPattern targetChannelPattern) {
        return new TargetedSendMessageActionBuilder(RequestInitiatedChannelTarget.forPattern(targetChannelPattern), this.transformers, this.transformerParameters);
    }

    public TargetedSendMessageActionBuilder toMatchingChannels(RequestPatternBuilder targetChannelPatternBuilder) {
        return new TargetedSendMessageActionBuilder(RequestInitiatedChannelTarget.forPattern(targetChannelPatternBuilder.build()), this.transformers, this.transformerParameters);
    }

    public static class TargetedSendMessageActionBuilder {
        private final ChannelTarget channelTarget;
        private final List<String> transformers;
        private final Parameters transformerParameters;

        TargetedSendMessageActionBuilder(ChannelTarget channelTarget, List<String> transformers, Parameters transformerParameters) {
            this.channelTarget = channelTarget;
            this.transformers = transformers;
            this.transformerParameters = transformerParameters;
        }

        public SendMessageAction withMessage(EntityDefinition body) {
            return new SendMessageAction(new MessageDefinition(body), this.channelTarget, this.transformers, this.transformerParameters);
        }

        public SendMessageAction withMessage(EntityDefinition.Builder<?> bodyBuilder) {
            return this.withMessage((EntityDefinition)bodyBuilder.build());
        }
    }
}

