/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.message.ChannelPattern;
import com.github.tomakehurst.wiremock.message.Message;
import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.message.MessagePattern;
import com.github.tomakehurst.wiremock.message.MessageTrigger;
import com.github.tomakehurst.wiremock.message.RequestInitiatedChannelPattern;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class IncomingMessageTrigger
implements MessageTrigger {
    public static final IncomingMessageTrigger ANYTHING = new IncomingMessageTrigger(null, null);
    private final ChannelPattern channelPattern;
    private final MessagePattern messagePattern;

    @JsonCreator
    public IncomingMessageTrigger(@JsonProperty(value="channel") ChannelPattern channelPattern, @JsonProperty(value="message") MessagePattern messagePattern) {
        this.channelPattern = channelPattern;
        this.messagePattern = messagePattern;
    }

    public ChannelPattern getChannel() {
        return this.channelPattern;
    }

    public MessagePattern getMessage() {
        return this.messagePattern;
    }

    @JsonIgnore
    public ContentPattern<?> getBodyPattern() {
        return this.messagePattern != null ? this.messagePattern.getBodyPattern() : null;
    }

    @JsonIgnore
    public RequestPattern getInitiatingRequestPattern() {
        if (this.channelPattern instanceof RequestInitiatedChannelPattern) {
            return ((RequestInitiatedChannelPattern)this.channelPattern).getInitiatingRequestPattern();
        }
        return null;
    }

    public boolean matches(MessageChannel channel, Message message) {
        if (this.channelPattern != null && !this.channelPattern.matches(channel)) {
            return false;
        }
        if (this.messagePattern != null) {
            return this.messagePattern.matches(channel, message);
        }
        return true;
    }

    public boolean matches(Request channelRequest, Message message) {
        RequestInitiatedChannelPattern requestInitiated;
        ChannelPattern channelPattern = this.channelPattern;
        if (channelPattern instanceof RequestInitiatedChannelPattern ? !(requestInitiated = (RequestInitiatedChannelPattern)channelPattern).matches(channelRequest) : this.channelPattern != null) {
            return false;
        }
        if (this.messagePattern != null) {
            return this.messagePattern.matches(channelRequest, message);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncomingMessageTrigger that = (IncomingMessageTrigger)o;
        return Objects.equals(this.channelPattern, that.channelPattern) && Objects.equals(this.messagePattern, that.messagePattern);
    }

    public int hashCode() {
        return Objects.hash(this.channelPattern, this.messagePattern);
    }
}

